//---------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//----------------------------------------------------------------------------
//
// description: cdevDataEntry.h
//	Self describing data class.  Designed to hold individual tagged data
//	items within a cdevData class.
//
// Author: Walt Akers & Danjin Wu
//
// Revision History:
//   $Log: cdevTypes.h,v $
//   Revision 1.4  2001/08/14 18:14:29  chen
//   minor changes
//
//   Revision 1.3  2001/08/13 19:06:00  chen
//   Redefine cdevData Type sequence
//
//   Revision 1.2  2001/07/25 14:28:35  chen
//   64 BIT Initial Port
//
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:34:12  bickley
// Added cmlog to application development system.
//
// Revision 1.3  1995/09/06  18:35:11  danjin
// added time stamp structure type
//
// Revision 1.2  1995/07/14  13:25:32  akers
// Header files added to support the changes specified at June 95 Review
//
//
//                                       
//--------------------------------------------------------------------------

#ifndef _CDEV_TYPES_H
#define _CDEV_TYPES_H

#include <stddef.h>

/*     64 bit definition                                           */
#if defined (__sparcv9) || defined (__alpha)
#define CDEV_64BIT_LONG
#endif 

typedef unsigned char BYTE;

enum cdevDataTypes 
	{
	CDEV_BYTE, 
	CDEV_INT16, 
	CDEV_UINT16,
	CDEV_INT32,
	CDEV_UINT32,
	CDEV_FLOAT, 
	CDEV_DOUBLE, 
	CDEV_STRING, 
	CDEV_TIMESTAMP,
	CDEV_INVALID,
	CDEV_INT64,
	CDEV_UINT64,
	CDEV_NTS
	};

typedef struct
	{
	  unsigned offset;
	  unsigned length;
	} cdevBounds;

// cdev time struct 
#ifdef CDEV_64BIT_LONG
typedef unsigned int  cdev_tf;
#else
typedef unsigned long cdev_tf;
#endif

typedef struct {
    cdev_tf    secPastEpoch;    //seconds since Jan. 1, 1970
    cdev_tf    nsec;            //nanoseconds within second 
} cdev_TS_STAMP;

#endif
