//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Utility prototypes and inline functions for cdev.
//
// Author:  Walt Akers
//
// Revision History:
//   $Log: cdevCommon.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:33:44  bickley
// Added cmlog to application development system.
//
// Revision 1.2  1995/10/30  13:33:16  akers
// Added cdev specific version of strncpy
//
//
//
#ifndef _CDEV_COMMON_H
#define _CDEV_COMMON_H

#include <stdio.h>
#include <stddef.h>

// *****************************************************************************
// * cdevStrncpy:
// *	This is an alternative to the strncpy routine.  This function will 
// *	always NULL terminate the resulting string, strncpy does not.
// *****************************************************************************
inline char * cdevStrncpy(char *s1, const char *s2, size_t n)
	{
	char * result = s1;
	if(s1!=NULL)
		{
		while(s2!=NULL && *s2 && (n--)>1) *(s1++) = *(s2++);
		*s1=0;
		}
	return result;
	}

#endif /* _CDEV_COMMON_H */
