%{

/*----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//----------------------------------------------------------------------------
//
// Description:    
//   Parser cmlog logic expression
//                                                  
// Author:  Jie Chen  
//       
// Revision History:
//   $Log: cmlog_xui_logic.y,v $
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:35  bickley
// Added cmlog to application development system.
//
//                                       
//---------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <cmlogXuiLogic.h>

#ifdef __VMS
/* VMS does not have unlink but it does have the function remove().
   Note that remove() may not be able to delete directory files . */
#define unlink(tmp) (remove((tmp)))
#endif

%}

%union {
  int    ival;
  double dval;
  char *string;
}

%token <string> TAGNAME, CSTRING
%token <dval>   DVALUE
%token EQUAL, LESS, GREATER, NOTEQUAL
%token LESSOREQUAL, GREATEROREQUAL
%token LEFTP, RIGHTP, OR, AND, LIKE, NOT, CERROR
%token <ival> IVALUE
%type  <string> logic_exp, cmlog_logic

%left OR
%left AND
%left NOT
%left EQUAL LESS GREATER NOTEQUAL LESSOREQUAL GREATEROREQUAL LIKE

%%
cmlog_qstring: cmlog_logic { set_cmlog_xui_qstr ($1); free ($1);}

cmlog_logic: logic_exp {$$ = cmlog_xui_strdup ($1); free ($1);}
      | cmlog_logic AND cmlog_logic {char temp[256];
      sprintf (temp,"%s && %s", $1, $3);
      $$ = cmlog_xui_strdup (temp);
      free ($1); free ($3);
      }
      | cmlog_logic OR cmlog_logic {char temp[256];
      sprintf (temp,"%s || %s", $1, $3);
      $$ = cmlog_xui_strdup (temp);
      free ($1); free ($3);
      }
      | NOT cmlog_logic {char temp[256];
      sprintf (temp,"!%s", $2);
      $$ = cmlog_xui_strdup (temp);
      free ($2);
      }
      | LEFTP cmlog_logic RIGHTP {char temp[256];
      sprintf (temp,"(%s)", $2);
      $$ = cmlog_xui_strdup (temp);
      free ($2);
      }
      ;

logic_exp: TAGNAME EQUAL IVALUE {char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s==%d",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1);}
      | TAGNAME EQUAL DVALUE    {char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s==%lf",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1);} 
      | TAGNAME EQUAL CSTRING   {char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s == '%s'",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1); free ($3);}
      | TAGNAME LESS  IVALUE    {char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s<%d",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1);}
      | TAGNAME LESS  DVALUE    {char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s<%lf",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1);}
      | TAGNAME GREATER IVALUE  {char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s>%d",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1);}
      | TAGNAME GREATER DVALUE  {char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s>%lf",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1);}
      | TAGNAME LESSOREQUAL IVALUE{char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s<=%d",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1);}
      | TAGNAME LESSOREQUAL DVALUE{char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s<=%lf",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1);}
      | TAGNAME GREATEROREQUAL IVALUE{char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s>=%d",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1);}
      | TAGNAME GREATEROREQUAL DVALUE{char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s>=%lf",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1);}
      | TAGNAME NOTEQUAL IVALUE{char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s!=%d",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1);}
      | TAGNAME NOTEQUAL DVALUE{char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s!=%lf",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1);}
      | TAGNAME NOTEQUAL CSTRING{char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s!='%s'",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1); free ($3);}
      | TAGNAME LIKE CSTRING   {char  temp[128];
                                 char* tag = cmlog_xui_title_match ($1);
                                 if (!tag) YYABORT;
				 else 
				   sprintf (temp, "%s like '%s'",tag, $3);
                                 $$ = cmlog_xui_strdup (temp);
                                 free ($1); free ($3);}
      ;
%%
