//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Updating buffer size button in preferences menu
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiUbuf.h,v $
//   Revision 1.2  2000/06/20 19:36:44  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:19  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_UBUF_H
#define _CMLOG_XUI_UBUF_H

#include <stdio.h>
#include <string.h>
#include <cmlogXuiMenuBtn.h>

class cmlogXuiUbufDialog;

class cmlogXuiUbuf: public cmlogXuiMenuBtn
{
public:
  // constructor and destructor
  cmlogXuiUbuf  (const char* name, int active,
		 const char* acc, const char* acc_text,
		 cmlogXuiMenuWin* win,
		 cmlogXuiBrowser& browser);
  ~cmlogXuiUbuf (void);

  void changeUbufsize (int size);
  int  ubufSize       (void) const;

  virtual const char* className (void) const {return "cmlogXuiUbuf";}

protected:
  // inherited operations
  virtual void doit   (void);
  virtual void undoit (void);

private:
  // disconnect dialog box
  cmlogXuiUbufDialog* dialog_;
};
#endif
