//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of ubuf size menu in the preference menu
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiUbuf.cc,v $
//   Revision 1.2  2000/06/20 19:36:44  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:17  bickley
// Added cmlog to application development system.
//
//
//
#include <cmlogXuiUbufDialog.h>
#include <cmlogXuiMenuWin.h>
#include <cmlogXuiDisp.h>
#include "cmlogXuiUbuf.h"

cmlogXuiUbuf::cmlogXuiUbuf (const char* name, int active,
			    const char* acc, const char* acc_text,
			    cmlogXuiMenuWin* win,
			    cmlogXuiBrowser& browser)
:cmlogXuiMenuBtn (name, active, acc, acc_text, win, browser), dialog_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiUbuf Class Object\n");
#endif
}

cmlogXuiUbuf::~cmlogXuiUbuf (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiUbuf Class Object\n");
#endif
}

void
cmlogXuiUbuf::doit (void)
{
  if (!dialog_) {
    dialog_ = new cmlogXuiUbufDialog (this,
				      "Buffer Size Dialog", 
				      "Buffer Size Dialog", browser_);
    dialog_->init ();
  }
  dialog_->popup ();
}

void
cmlogXuiUbuf::undoit (void)
{
  // empty
}

void
cmlogXuiUbuf::changeUbufsize (int size)
{  
  cmlogXuiDisp* disp = menuwin_->displayWindow ();
  disp->updatingBufSize (size);
}

int
cmlogXuiUbuf::ubufSize (void) const
{
  cmlogXuiDisp* disp = menuwin_->displayWindow ();
  return disp->updatingBufSize ();
}
