//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlogXui Top Level Window
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiTopW.h,v $
//   Revision 1.2  2000/06/20 19:36:44  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:16  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_XUI_TOPW_H
#define _CMLOG_XUI_TOPW_H

#include <XcodaTopLevel.h>
#include <cmlogXuiBrowser.h>

class cmlogXuiMenuWin;
class cmlogXuiDisp;

class cmlogXuiTopW: public XcodaTopLevel
{
public:
  // constructor and destructor
  cmlogXuiTopW   (char* name, cmlogXuiBrowser* handler, int rmHandlerOnQuit = 1);
  ~cmlogXuiTopW  (void);

  // configure the window to refelect connection state
  void connectionConfig (void);
  void disconnectConfig (void);
  void serverCrashConfig (void);

  // return browser
  cmlogXuiBrowser* browser (void) const {return browser_;}

  // top window update current time
  void updateTime       (time_t t);

  // force to process x event
  void forceProcessX (void);

  // return real display window
  cmlogXuiDisp* displayWindow (void) const;

protected:
  virtual Widget CreateBaseWidget (Widget parent);

private:
  cmlogXuiMenuWin* window_;
  cmlogXuiBrowser* browser_;
  // flag to tell whether to remove (delete) browser inside destructor
  int              doDeleteBrowser_;
};
#endif
