//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlog xui time selector
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiTimeSel.cc,v $
//   Revision 1.2  2000/06/20 19:36:44  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:05  bickley
// Added cmlog to application development system.
//
//
//
#include <ctype.h>
#include <Xm/Form.h>
#include <Xm/LabelG.h>
#include <Xm/ArrowBG.h>
#include <Xm/TextF.h>
#include "cmlogXuiTimeSel.h"

cmlogXuiTimeSel::cmlogXuiTimeSel (Widget parent, const char* name)
:XcodaUi (name), parent_ (parent), date_ ()
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiTimeSel Class Object\n");
#endif
  // empty
}

cmlogXuiTimeSel::~cmlogXuiTimeSel (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiTimeSel Class Object\n");
#endif
  // empty
}

void
cmlogXuiTimeSel::init (void)
{
  Arg arg[20];
  int ac = 0;
  XmString t1;

  _w = XtCreateWidget ("time_row_column", xmFormWidgetClass,
		       parent_, arg, ac);
  ac = 0;

  // create widgets  to handle year input
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  Widget yform = XtCreateWidget ("year_form", xmFormWidgetClass,
				 _w, arg, ac);
  ac = 0;

  t1 = XmStringCreateSimple ((char *)("Year "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 30); ac++;
  XtSetArg (arg[ac], XmNlabelString, t1); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_END); ac++;
  Widget temp = XtCreateManagedWidget ("temp", xmLabelGadgetClass,
				       yform, arg, ac);
  ac = 0;
  XmStringFree (t1);
  
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 4); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNbottomPosition, 50); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_UP); ac++;
  yup_ = XtCreateManagedWidget ("cmlog_time_yup", xmArrowButtonGadgetClass,
				yform, arg, ac);
  ac = 0;

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNtopPosition, 50); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 4); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_DOWN); ac++;
  ydn_ = XtCreateManagedWidget ("cmlog_time_ydn", xmArrowButtonGadgetClass,
				yform, arg, ac);
  ac = 0;  

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, temp); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNrightWidget, yup_); ac++;
  XtSetArg (arg[ac], XmNcolumns, 14); ac++;
  XtSetArg (arg[ac], XmNeditable, False); ac++;
  XtSetArg (arg[ac], XmNcursorPositionVisible, False); ac++;
  ylabel_ = XtCreateManagedWidget ("cmlog_year_label", 
				   xmTextFieldWidgetClass, yform,
				   arg, ac);
  ac = 0;
  
  XtManageChild (yform);

  
  // create month widgets
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, yform); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  Widget mform = XtCreateWidget ("month_form", xmFormWidgetClass,
				 _w, arg, ac);
  ac = 0;

  t1 = XmStringCreateSimple ((char *)("Month "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 30); ac++;
  XtSetArg (arg[ac], XmNlabelString, t1); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_END); ac++;
  temp = XtCreateManagedWidget ("temp", xmLabelGadgetClass,
				mform, arg, ac);
  ac = 0;
  XmStringFree (t1);
  

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 4); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNbottomPosition, 50); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_UP); ac++;
  mup_ = XtCreateManagedWidget ("cmlog_time_mup", xmArrowButtonGadgetClass,
				mform, arg, ac);
  ac = 0;

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNtopPosition, 50); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 4); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_DOWN); ac++;
  mdn_ = XtCreateManagedWidget ("cmlog_time_mdn", xmArrowButtonGadgetClass,
				mform, arg, ac);
  ac = 0;  

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, temp); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNrightWidget, mup_); ac++;
  XtSetArg (arg[ac], XmNcolumns, 14); ac++;
  XtSetArg (arg[ac], XmNeditable, False); ac++;
  XtSetArg (arg[ac], XmNcursorPositionVisible, False); ac++;  
  mlabel_ = XtCreateManagedWidget ("cmlog_month_label", 
				   xmTextFieldWidgetClass, mform,
				   arg, ac);
  ac = 0;
  
  XtManageChild (mform);


  // create day widgets
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, mform); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  Widget dform = XtCreateWidget ("day_form", xmFormWidgetClass,
				 _w, arg, ac);
  ac = 0;

  t1 = XmStringCreateSimple ((char *)("Day "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 30); ac++;
  XtSetArg (arg[ac], XmNlabelString, t1); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_END); ac++;
  temp = XtCreateManagedWidget ("temp", xmLabelGadgetClass,
				dform, arg, ac);
  ac = 0;
  XmStringFree (t1);
  

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 4); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNbottomPosition, 50); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_UP); ac++;
  dup_ = XtCreateManagedWidget ("cmlog_time_dup", xmArrowButtonGadgetClass,
				dform, arg, ac);
  ac = 0;

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNtopPosition, 50); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 4); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_DOWN); ac++;
  ddn_ = XtCreateManagedWidget ("cmlog_time_ddn", xmArrowButtonGadgetClass,
				dform, arg, ac);
  ac = 0;  

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, temp); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNrightWidget, dup_); ac++;
  XtSetArg (arg[ac], XmNcolumns, 14); ac++;
  XtSetArg (arg[ac], XmNeditable, True); ac++;
  dlabel_ = XtCreateManagedWidget ("cmlog_day_label", 
				   xmTextFieldWidgetClass, dform,
				   arg, ac);
  ac = 0;

  XtManageChild (dform);

  // create hour widgets
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, dform); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  Widget hform = XtCreateWidget ("hour_form", xmFormWidgetClass,
				 _w, arg, ac);
  ac = 0;

  t1 = XmStringCreateSimple ((char *)("Hour "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 30); ac++;
  XtSetArg (arg[ac], XmNlabelString, t1); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_END); ac++;
  temp = XtCreateManagedWidget ("temp", xmLabelGadgetClass,
				hform, arg, ac);
  ac = 0;
  XmStringFree (t1);
  

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 4); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNbottomPosition, 50); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_UP); ac++;
  hup_ = XtCreateManagedWidget ("cmlog_time_hup", xmArrowButtonGadgetClass,
				hform, arg, ac);
  ac = 0;

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNtopPosition, 50); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 4); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_DOWN); ac++;
  hdn_ = XtCreateManagedWidget ("cmlog_time_hdn", xmArrowButtonGadgetClass,
				  hform, arg, ac);
  ac = 0;  

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, temp); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNrightWidget, hup_); ac++;
  XtSetArg (arg[ac], XmNcolumns, 14); ac++;
  XtSetArg (arg[ac], XmNeditable, True); ac++;
  hlabel_ = XtCreateManagedWidget ("cmlog_hour_label", 
				   xmTextFieldWidgetClass, hform,
				   arg, ac);
  ac = 0;

  
  XtManageChild (hform);

  // create minute widgets
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, hform); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  Widget uform = XtCreateWidget ("minute_form", xmFormWidgetClass,
				 _w, arg, ac);
  ac = 0;

  t1 = XmStringCreateSimple ((char *)("Minute "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 30); ac++;
  XtSetArg (arg[ac], XmNlabelString, t1); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_END); ac++;
  temp = XtCreateManagedWidget ("temp", xmLabelGadgetClass,
				uform, arg, ac);
  ac = 0;
  XmStringFree (t1);
  
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 4); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNbottomPosition, 50); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_UP); ac++;
  uup_ = XtCreateManagedWidget ("cmlog_time_uup", xmArrowButtonGadgetClass,
				uform, arg, ac);
  ac = 0;

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNtopPosition, 50); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 4); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_DOWN); ac++;
  udn_ = XtCreateManagedWidget ("cmlog_time_udn", xmArrowButtonGadgetClass,
				uform, arg, ac);
  ac = 0;  

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, temp); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNrightWidget, uup_); ac++;
  XtSetArg (arg[ac], XmNcolumns, 14); ac++;
  XtSetArg (arg[ac], XmNeditable, True); ac++;
  ulabel_ = XtCreateManagedWidget ("cmlog_minute_label", 
				   xmTextFieldWidgetClass, uform,
				   arg, ac);
  ac = 0;

  XtManageChild (uform);

  // create second widgets
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, uform); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  Widget sform = XtCreateWidget ("second_form", xmFormWidgetClass,
				 _w, arg, ac);
  ac = 0;

  t1 = XmStringCreateSimple ((char *)("Second "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 30); ac++;
  XtSetArg (arg[ac], XmNlabelString, t1); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_END); ac++;
  temp = XtCreateManagedWidget ("temp", xmLabelGadgetClass,
				sform, arg, ac);
  ac = 0;
  XmStringFree (t1);
  
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 4); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNbottomPosition, 50); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_UP); ac++;
  sup_ = XtCreateManagedWidget ("cmlog_time_sup", xmArrowButtonGadgetClass,
				sform, arg, ac);
  ac = 0;

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNtopPosition, 50); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 4); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_DOWN); ac++;
  sdn_ = XtCreateManagedWidget ("cmlog_time_sdn", xmArrowButtonGadgetClass,
				sform, arg, ac);
  ac = 0;  

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, temp); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNrightWidget, sup_); ac++;
  XtSetArg (arg[ac], XmNcolumns, 14); ac++;
  XtSetArg (arg[ac], XmNeditable, True); ac++;
  slabel_ = XtCreateManagedWidget ("cmlog_second_label", 
				   xmTextFieldWidgetClass, sform,
				   arg, ac);
  ac = 0;
  
  XtManageChild (sform);


  // install destroy handler
  installDestroyHandler ();

  // display current time
  display ();

  XtManageChild (_w);

  // add all those callbacks for arrow buttons
  // year widgets
  XtAddCallback (yup_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::yearArrowUp),
		 (XtPointer)this);
  XtAddCallback (ydn_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::yearArrowDn),
		 (XtPointer)this);

  // month widgets
  XtAddCallback (mup_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::monthArrowUp),
		 (XtPointer)this);
  XtAddCallback (mdn_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::monthArrowDn),
		 (XtPointer)this);

  // day widgets
  XtAddCallback (dup_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::dayArrowUp),
		 (XtPointer)this);
  XtAddCallback (ddn_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::dayArrowDn),
		 (XtPointer)this);

  // hour widgets
  XtAddCallback (hup_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::hourArrowUp),
		 (XtPointer)this);
  XtAddCallback (hdn_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::hourArrowDn),
		 (XtPointer)this);

  // minute widgets
  XtAddCallback (uup_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::minArrowUp),
		 (XtPointer)this);
  XtAddCallback (udn_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::minArrowDn),
		 (XtPointer)this);

  // second widgets
  XtAddCallback (sup_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::secArrowUp),
		 (XtPointer)this);
  XtAddCallback (sdn_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::secArrowDn),
		 (XtPointer)this);

  // add day label activate callback
  XtAddCallback (dlabel_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::dayinput),
		 (XtPointer)this);

  XtAddCallback (hlabel_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::hourinput),
		 (XtPointer)this);

  XtAddCallback (ulabel_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::minuteinput),
		 (XtPointer)this);

  XtAddCallback (slabel_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiTimeSel::secondinput),
		 (XtPointer)this);
}

char *
cmlogXuiTimeSel::date (void)
{
  return date_.date ();
}

int
cmlogXuiTimeSel::date (double& time)
{
  return date_.date (time);
}

void
cmlogXuiTimeSel::display (void)
{
  Arg arg[20];
  int ac = 0;
  char temp[80];

  // year
  sprintf (temp, "%14d", date_.year ());
  XtSetArg (arg[ac], XmNvalue, temp); ac++;
  XtSetValues (ylabel_, arg, ac); 
  ac = 0;

  // month
  char* mon = date_.month ();
  sprintf (temp, "%14s", mon);
  XtSetArg (arg[ac], XmNvalue, temp); ac++;
  XtSetValues (mlabel_, arg, ac); 
  ac = 0;
  delete []mon;

  // day
  sprintf (temp, "%14d", date_.day ());
  XtSetArg (arg[ac], XmNvalue, temp); ac++;
  XtSetValues (dlabel_, arg, ac); 
  ac = 0;

  // hour
  sprintf (temp, "%14d", date_.hour ());
  XtSetArg (arg[ac], XmNvalue, temp); ac++;
  XtSetValues (hlabel_, arg, ac); 
  ac = 0;

  // minute
  sprintf (temp, "%14d", date_.minute ());
  XtSetArg (arg[ac], XmNvalue, temp); ac++;
  XtSetValues (ulabel_, arg, ac); 
  ac = 0;

  // second
  sprintf (temp, "%14d", date_.second ());
  XtSetArg (arg[ac], XmNvalue, temp); ac++;
  XtSetValues (slabel_, arg, ac); 
  ac = 0;
}

void
cmlogXuiTimeSel::yearArrowUp (Widget w, XtPointer data,
			      XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  unsigned int y = obj->date_.year ();
  
  y++;

  obj->date_.year (y);

  obj->display ();
}

void
cmlogXuiTimeSel::yearArrowDn (Widget w, XtPointer data,
			      XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;

  unsigned int y = obj->date_.year ();

  y--;

  if (y < 1)
    y = 1;
  obj->date_.year (y);

  obj->display ();
}

void
cmlogXuiTimeSel::monthArrowUp (Widget w, XtPointer data,
			       XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  
  unsigned int m = obj->date_.month_;

  if (m == 12)
    m = 1;
  else 
    m ++;

  obj->date_.month (m);

  obj->display ();
}

void
cmlogXuiTimeSel::monthArrowDn (Widget w, XtPointer data,
			       XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  
  unsigned int m = obj->date_.month_;

  if (m == 1)
    m = 12;
  else 
    m --;

  obj->date_.month (m);

  obj->display ();
}

void
cmlogXuiTimeSel::dayArrowUp (Widget w, XtPointer data,
			     XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  
  unsigned int day = obj->date_.day_;
  unsigned int m = obj->date_.month_;
  unsigned int maxdays = obj->date_.maxDays (m);

  if (day == maxdays)
    day = 1;
  else 
    day ++;

  obj->date_.day (day);

  obj->display ();
}

void
cmlogXuiTimeSel::dayArrowDn (Widget w, XtPointer data,
			     XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  
  unsigned int day = obj->date_.day_;
  unsigned int m = obj->date_.month_;
  unsigned int maxdays = obj->date_.maxDays (m);

  if (day == 1)
    day = maxdays;
  else 
    day --;

  obj->date_.day (day);

  obj->display ();
}


void
cmlogXuiTimeSel::hourArrowUp (Widget w, XtPointer data,
			      XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  
  unsigned int h = obj->date_.hour_;

  if (h == 23)
    h = 0;
  else 
    h ++;

  obj->date_.hour (h);

  obj->display ();
}


void
cmlogXuiTimeSel::hourArrowDn (Widget w, XtPointer data,
			      XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  
  unsigned int h = obj->date_.hour_;

  if (h == 0)
    h = 23;
  else 
    h --;

  obj->date_.hour (h);

  obj->display ();
}


void
cmlogXuiTimeSel::minArrowUp (Widget w, XtPointer data,
			     XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  
  unsigned int m = obj->date_.minute_;

  if (m == 59)
    m = 0;
  else 
    m ++;

  obj->date_.minute (m);

  obj->display ();
}

void
cmlogXuiTimeSel::minArrowDn (Widget w, XtPointer data,
			     XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  
  unsigned int m = obj->date_.minute_;

  if (m == 0)
    m = 59;
  else 
    m --;

  obj->date_.minute (m);

  obj->display ();
}

void
cmlogXuiTimeSel::secArrowUp (Widget w, XtPointer data,
			     XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  
  unsigned int s = obj->date_.second_;

  if (s == 59)
    s = 0;
  else 
    s ++;

  obj->date_.second (s);

  obj->display ();
}

void
cmlogXuiTimeSel::secArrowDn (Widget w, XtPointer data,
			     XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  
  unsigned int s = obj->date_.second_;

  if (s == 0)
    s = 59;
  else 
    s --;

  obj->date_.second (s);

  obj->display ();
}

void
cmlogXuiTimeSel::reset (void)
{
  date_.reset ();
  display ();
}


void
cmlogXuiTimeSel::dayinput (Widget w, XtPointer data,
			   XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  char* tstr;
  int   tday;

  unsigned int day = obj->date_.day_;
  unsigned int m = obj->date_.month_;
  unsigned int maxdays = obj->date_.maxDays (m);

  tstr = XmTextFieldGetString (w);
  if (!tstr || !*tstr)
    return;

  if (sscanf (tstr, "%d", &tday) == 1) {
    if (tday > 0 && tday <= maxdays)
      obj->date_.day (tday);
  }

  XtFree (tstr);
  obj->display ();
}


void
cmlogXuiTimeSel::hourinput (Widget w, XtPointer data,
			    XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  char* tstr;
  int   th;

  tstr = XmTextFieldGetString (w);
  if (!tstr || !*tstr)
    return;

  if (sscanf (tstr, "%d", &th) == 1) {
    if (th >= 0 && th <= 23)
      obj->date_.hour (th);
  }
  XtFree (tstr);
  obj->display ();
}

void
cmlogXuiTimeSel::minuteinput (Widget w, XtPointer data,
			      XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  char* tstr;
  int   tm;

  tstr = XmTextFieldGetString (w);
  if (!tstr || !*tstr)
    return;

  if (sscanf (tstr, "%d", &tm) == 1) {
    if (tm >= 0 && tm < 60)
      obj->date_.minute (tm);
  }
  XtFree (tstr);
  obj->display ();
}

void
cmlogXuiTimeSel::secondinput (Widget w, XtPointer data,
			      XmAnyCallbackStruct* cbs)
{
  cmlogXuiTimeSel* obj = (cmlogXuiTimeSel *)data;
  char* tstr;
  int   ts;

  tstr = XmTextFieldGetString (w);
  if (!tstr || !*tstr)
    return;

  if (sscanf (tstr, "%d", &ts) == 1) {
    if (ts >= 0 && ts < 60)
      obj->date_.second (ts);
  }
  XtFree (tstr);
  obj->display ();
}

