//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG File Menu Save Dialog Box
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiSaveDialog.h,v $
//   Revision 1.2  2000/06/20 19:36:43  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
//
//
#ifndef _CMLOG_XUI_SAVE_DIALOG_H
#define _CMLOG_XUI_SAVE_DIALOG_H

#include <stdio.h>
#include <string.h>
#include <XcodaFormDialog.h>
#include <cmlogXuiBrowser.h>

class cmlogXuiSaveFileDialog;
class cmlogXuiSave;

class cmlogXuiSaveDialog : public XcodaFormDialog
{
public:
  // constructor and destructor
  cmlogXuiSaveDialog  (cmlogXuiSave* savebutton, 
		       const char* name, 
		       const char* title, cmlogXuiBrowser& browser);
  ~cmlogXuiSaveDialog (void);

  void      popup     (void);

  void      setFileName (char* name);

  void      setPointedMsgNumber (int number);
  
  const char* className (void) const {return "cmlogXuiSaveDialog";}

protected:
  // inherited operation
  void createFormChildren (void);

  // all button callbacks
  static void fileButtonCallback (Widget w, XtPointer data,
				  XmAnyCallbackStruct* cbs);

  static void fromArrowUpCallback (Widget w, XtPointer data,
				   XmAnyCallbackStruct* cbs);
  static void fromArrowDownCallback (Widget w, XtPointer data,
				     XmAnyCallbackStruct* cbs);

  static void toArrowUpCallback (Widget w, XtPointer data,
				 XmAnyCallbackStruct* cbs);
  static void toArrowDownCallback (Widget w, XtPointer data,
				   XmAnyCallbackStruct* cbs);

  static void okCallback (Widget w, XtPointer data,
			  XmAnyCallbackStruct* cbs);

  static void cancelCallback (Widget w, XtPointer data,
			      XmAnyCallbackStruct* cbs);

private:
  // parent button
  cmlogXuiSave* save_;

  // network handler
  cmlogXuiBrowser& browser_;

  // file selection dialog
  cmlogXuiSaveFileDialog* fdialog_;

  // all widgets
  Widget ok_;
  Widget cancel_;

  Widget from_;
  Widget to_;
  Widget currline_;
  Widget filebutton_;
  Widget file_;
  Widget pagetog_;

  // friend class 
  friend class cmlogXuiSaveFileDialog;

};
#endif



