//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      File Menu Save Command
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiSave.h,v $
//   Revision 1.2  2000/06/20 19:36:43  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
//
//
#ifndef _CMLOG_XUI_SAVE_H
#define _CMLOG_XUI_SAVE_H

#include <stdio.h>
#include <string.h>
#include <cmlogXuiMenuBtn.h>

class cmlogXuiSaveDialog;

class cmlogXuiSave: public cmlogXuiMenuBtn
{
public:
  // constructor and destructor
  cmlogXuiSave  (const char* name, int active,
		 const char* acc, const char* acc_text,
		 cmlogXuiMenuWin* win,
		 cmlogXuiBrowser& browser);
  ~cmlogXuiSave (void);

  int numMsgsInBuffer (void);

  // operation
  int doSave    (char* filename, int fromline, int endline,
		 int savecurrpage);

  // set msg number uner cursor
  void pointedMsgNumber (int num);

  virtual const char* className (void) const {return "cmlogXuiSave";}
  
protected:
  // inherited operations
  virtual void doit   (void);
  virtual void undoit (void);

private:
  cmlogXuiSaveDialog* dialog_;
};
#endif


