//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogXuiQueryProg Class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiQueryProg.cc,v $
//   Revision 1.2  2000/06/20 19:36:42  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:54  bickley
// Added cmlog to application development system.
//
//
//
#include <Xm/Form.h>
#include <Xm/LabelG.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/ToggleBG.h>
#include <Xm/Scale.h>
#include <Xm/TextF.h>
#include <cmlogXuiLogicSup.h>
#include <cmlogXuiDisp.h>
#include <cmlogXuiMenuWin.h>
#include "cmlogXuiQueryProg.h"

cmlogXuiQueryProg::cmlogXuiQueryProg (cmlogXuiDisp* disp,
				      char* name, char* title,
				      cmlogXuiBrowser& browser)
:XcodaFormDialog (disp->baseWidget(), name, title), disp_ (disp),
 browser_ (browser)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Create cmlogXuiQueryProg Class Object\n");
#endif
  // empty
}

cmlogXuiQueryProg::~cmlogXuiQueryProg (void)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Delete cmlogXuiQueryProg Class Object\n");
#endif
  // empty
}

void
cmlogXuiQueryProg::createFormChildren (void)
{
  Arg arg[20];
  int ac = 0;
  XmString t;

  // create top title
  t = XmStringCreateSimple ((char *)("Do you want more messages ?"));
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  title_ = XtCreateManagedWidget ("prog_title",
				  xmLabelGadgetClass, _w,
				  arg, ac);
  ac = 0;
  XmStringFree (t);


  // create action form
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;  
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  Widget act_form = XtCreateWidget ("prog_act_form",
				    xmFormWidgetClass,
				    _w, arg, ac);
  ac = 0;

  t = XmStringCreateSimple ((char *)(" Yes  "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNleftPosition, 5); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNshowAsDefault, 1); ac++;
  ok_ = XtCreateManagedWidget ("prog_ok", xmPushButtonGadgetClass,
			       act_form, arg, ac);
  ac = 0;
  XmStringFree (t);

  t = XmStringCreateSimple ((char *)("  No  "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 95); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  cancel_ = XtCreateManagedWidget ("prog_cancel", xmPushButtonGadgetClass,
				   act_form, arg, ac);
  ac = 0;
  XmStringFree (t);

  XtManageChild (act_form);

  // create text widget
  t = XmStringCreateSimple ((char *)("Server searching message"));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, title_); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5) ;ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  Widget qlabel = XtCreateManagedWidget ("q_label", xmLabelGadgetClass,
					 _w, arg, ac);
  ac = 0;
  XmStringFree (t);

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, qlabel); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 2) ;ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;  
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  logic_ = XtCreateManagedWidget ("logic_input", xmTextFieldWidgetClass,
				  _w, arg, ac);
  ac = 0;


  // create scale widget
  t = XmStringCreateSimple ((char *)("Number of messages to search"));
  XtSetArg (arg[ac], XmNtitleString, t); ac++;
  XtSetArg (arg[ac], XmNminimum, 20); ac++;
  XtSetArg (arg[ac], XmNmaximum, 2000); ac++;
  XtSetArg (arg[ac], XmNshowValue, True); ac++;
  XtSetArg (arg[ac], XmNorientation, XmHORIZONTAL); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNbottomWidget, act_form); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5) ;ac++;
  scale_ = XtCreateManagedWidget ("cmlog_query_scale",
				  xmScaleWidgetClass,
				  _w, arg, ac);
  ac = 0;
  XmStringFree (t);

  // create toggle widget
  t = XmStringCreateSimple ((char *)("Get all messages"));
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNindicatorType, XmN_OF_MANY); ac++;
  XtSetArg (arg[ac], XmNvisibleWhenOff, True); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, logic_); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNbottomWidget, scale_); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5) ;ac++;
  toggle_ = XtCreateManagedWidget ("cmlog_query_toggle",
				   xmToggleButtonGadgetClass,
				   _w, arg, ac);
  ac = 0;
  XmStringFree (t);

  defaultButton (ok_);

  XtAddCallback (ok_, XmNactivateCallback, 
		 (XtCallbackProc)&(cmlogXuiQueryProg::okCallback),
		 (XtPointer)this);

  XtAddCallback (cancel_, XmNactivateCallback, 
		 (XtCallbackProc)&(cmlogXuiQueryProg::cancelCallback),
		 (XtPointer)this);

}

void
cmlogXuiQueryProg::popup (void)
{
  XmScaleSetValue (scale_, disp_->numberItemsToGet ());
  
  if (disp_->getAll ()) 
    XmToggleButtonGadgetSetState (toggle_, True, False);
  else
    XmToggleButtonGadgetSetState (toggle_, False, False);

  if (disp_->queryMessage ())
    XmTextFieldSetString (logic_, disp_->queryMessage ());

  XcodaFormDialog::popup ();
}

void
cmlogXuiQueryProg::ok (void)
{
  int numitems;
  int getall;
  char* qstr = 0;
  char* tstr;
  char* p;
  int   hasqstr = 0;

  XmScaleGetValue (scale_, &numitems);
  getall = XmToggleButtonGadgetGetState (toggle_);

  // get logic exprssion
  tstr = XmTextFieldGetString (logic_);

  if (tstr) {
    p = tstr;
    while (*p != '\0' && *p != '\n') {
      if (!isspace (*p)) {
	hasqstr = 1;
	break;
      }
      p++;
    }
    if (hasqstr) {
      qstr = cmlogXuiQueryString (tstr);
      XtFree (tstr);
      if (qstr == 0) {
	disp_->reportErrorMsg ("Searching message syntax error");
	return;
      }
    }
    else
      XtFree (tstr);
  }
  
  // move scroll window to the latest position
  disp_->scrollToBottom ();

  // popdown this box
  popdown ();

  if (browser_.query (disp_, disp_->lastDataTimeStamp () + 0.001,
		      disp_->endTime (), numitems, getall, qstr)
      == CMLOG_SUCCESS) {
    // set cursor to watch
    disp_-> defineCursor (XC_watch);

    // set query parameter to display window
    disp_->numberItemsToGet (numitems);
    if (getall)
      disp_->enableGetAll ();
    else
      disp_->disableGetAll ();

    // set query message
    disp_->queryMessage (qstr);
  }
}


void
cmlogXuiQueryProg::okCallback (Widget w, XtPointer data,
			       XmAnyCallbackStruct* cbs)
{
  cmlogXuiQueryProg* obj = (cmlogXuiQueryProg *)data;

  obj->ok ();
}

void
cmlogXuiQueryProg::cancel (void)
{
  cmlogXuiMenuWin* win = disp_->menuWindow ();
  
  popdown ();

  // set up end time to the window
  win->setEndTime ((time_t)disp_->lastDataTimeStamp ());
  win->normalConfig ();

  // reset number of found
  disp_->numberItemsFound (0);
}

void
cmlogXuiQueryProg::cancelCallback (Widget w, XtPointer data,
				   XmAnyCallbackStruct* cbs)
{
  cmlogXuiQueryProg* obj = (cmlogXuiQueryProg *)data;

  obj->cancel (); 
}

void
cmlogXuiQueryProg::setMessage (char* message)
{
  Arg arg[4];
  int ac = 0;
  XmString t = XmStringCreateSimple (message);

  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetValues (title_, arg, ac);
  ac = 0;
  XmStringFree (t);
}




