//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogXuiQueryCancelDialog Class
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiQueryCancelDialog.cc,v $
//   Revision 1.2  2000/06/20 19:36:41  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
//
//
#include <cmlogXuiDisp.h>
#include <cmlogXuiMenuWin.h>
#include "cmlogXuiQueryCancelDialog.h"

char* cmlogXuiQueryCancelDialog::serverMsg_ = (char *)"stopQuery";
const char* cmlogXuiQueryCancelDialog::dispMsg_ = "Do you want to stop this query ?";

cmlogXuiQueryCancelDialog::cmlogXuiQueryCancelDialog (cmlogXuiDisp* disp,
						      const char* name,
						      const char* title,
						      cmlogXuiBrowser& browser)
  :XcodaWarningDialog (disp->baseWidget(), name, title),
   disp_ (disp), browser_ (browser)
{
#ifdef _TRACE_OBJECTS
  printf ("                         Create cmlogXuiQueryCancelDialog Class Object\n");
#endif
  init ();
  setMessage (cmlogXuiQueryCancelDialog::dispMsg_);
}

cmlogXuiQueryCancelDialog::~cmlogXuiQueryCancelDialog (void)
{
#ifdef _TRACE_OBJECTS
  printf ("                         Delete cmlogXuiQueryCancelDialog Class Object\n");
#endif
  // empty
}

void
cmlogXuiQueryCancelDialog::ok (void)
{
  cdevData empty;
  if (browser_.queryCallback (cmlogXuiQueryCancelDialog::serverMsg_, empty,
			      &(cmlogXuiDisp::queryCallback),
			      (void *)disp_) != CMLOG_SUCCESS) 
    disp_->reportErrorMsg ("Cannot send cancel query command to the server");
    
}


			       
