//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of Query Message Dialog box
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiQMsgDialog.cc,v $
//   Revision 1.3  2000/06/20 19:36:40  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.2  1999/10/29 17:40:07  chen
//   support spaces and quotes in cmlogrc file
//
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
//
//
#include "cmlogXuiQueryDialog.h"
#include "cmlogXuiQMsgDialog.h"
#include "cmlogXuiSingleQMsg.h"
#include <cmlogXuiConfig.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushBG.h>
#include <Xm/TextF.h>
#include <XcodaSimpleOptionMenu.h>
#include <XcodaErrorDialog.h>

const char* cmlogXuiQMsgDialog::logicOptions_[]= 
{"&&", "||"};

const char* cmlogXuiQMsgDialog::logicOptionNames_[] = 
{"and", "or"};

int cmlogXuiQMsgDialog::numOptions_ = 2;

cmlogXuiQMsgDialog::cmlogXuiQMsgDialog(Widget textbase,
				       const char* name, const char* title)
  :XcodaFormDialog (textbase, name, title), parent_ (textbase),
   qmsgs_ (0), numMsgs_ (0), options_ (0), dialog_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Create cmlogXuiQMsgDialog Class Object\n");
#endif
  // empty
}

cmlogXuiQMsgDialog::~cmlogXuiQMsgDialog (void)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Delete cmlogXuiQMsgDialog Class Object\n");
#endif
  delete []qmsgs_;
  if (options_)
    delete []options_;
}

void
cmlogXuiQMsgDialog::createFormChildren (void)
{
  Arg arg[30];
  int ac = 0;
  int i;
  int j;
  XmString t;
  cmlogXuiConfig* config = cmlogXuiConfig::config ();
  numMsgs_ = config->numColumns ();
  char** titles = config->columnTitles();

  // create action form
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;  
  Widget act_form = XtCreateWidget ("act_form", xmFormWidgetClass,
				    _w, arg, ac);
  ac = 0;

  t = XmStringCreateSimple ((char *)("  Ok  "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNleftPosition, 5); ac++;
  XtSetArg (arg[ac], XmNshowAsDefault, 1); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  ok_ = XtCreateManagedWidget ("update_ok", xmPushButtonGadgetClass,
                               act_form, arg, ac);
  ac = 0;
  XmStringFree (t);

  t = XmStringCreateSimple ((char *)("Cancel"));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 95); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  cancel_ = XtCreateManagedWidget ("update_cancel", xmPushButtonGadgetClass,
                                   act_form, arg, ac);
  ac = 0;
  XmStringFree (t);

  // create a rowcolumn widget
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNbottomWidget, act_form); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNorientation, XmVERTICAL); ac++;
  XtSetArg (arg[ac], XmNnumColumns, 2* numMsgs_ - 1); ac++;
  XtSetArg (arg[ac], XmNspacing, 0); ac++;
  XtSetArg (arg[ac], XmNmarginHeight, 0); ac++;
  XtSetArg (arg[ac], XmNmarginWidth, 0); ac++;
  Widget row = XtCreateWidget ("qmsgdialogrow", xmRowColumnWidgetClass,
			       _w, arg, ac);
  ac = 0;

  // create form widgets that hold query msgs and options
  Widget *forms = new Widget[2*numMsgs_ - 1];
  for (i = 0; i < 2* numMsgs_ - 1; i++) 
    forms[i] = XtCreateWidget ("qmsgform", xmFormWidgetClass,
			       row, 0, 0);


  qmsgs_ = new cmlogXuiSingleQMsg*[numMsgs_];

  for (i = 0; i < numMsgs_; i++) {
    qmsgs_[i] = new cmlogXuiSingleQMsg (this, forms[2*i],
					"singleqmsg", titles[i]);

    XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetValues (qmsgs_[i]->baseWidget(), arg, ac);
    ac = 0;
  }

  if (numMsgs_ > 1) {
    options_ = new XcodaSimpleOptionMenu*[numMsgs_ - 1];
    for (i = 0; i < numMsgs_ - 1; i++) {
      options_[i] = new XcodaSimpleOptionMenu (forms[2*i + 1],
					       "andoroption",
					       " ");
      options_[i]->init();
      options_[i]->addEntries (cmlogXuiQMsgDialog::logicOptionNames_,
			       cmlogXuiQMsgDialog::numOptions_);
      XtManageChild (options_[i]->baseWidget());

      // center this widget
      Dimension swd = 0;
      XtSetArg    (arg[ac], XmNwidth, &swd); ac++;
      XtGetValues (options_[i]->baseWidget(), arg, ac); 
      ac = 0;

      XtSetArg    (arg[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
      XtSetArg    (arg[ac], XmNleftPosition, 50); ac++;
      XtSetArg    (arg[ac], XmNleftOffset, -swd/2); ac++;
      XtSetArg    (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
      XtSetArg    (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
      XtSetValues (options_[i]->baseWidget(), arg, ac);
      ac = 0;
    }
  }
  
  // manage all widgets
  for (i = 0; i < 2*numMsgs_ - 1; i++)
    XtManageChild (forms[i]);

  XtManageChild (row);
  XtManageChild (act_form);

  // free memory
  delete []forms;

  // set default button
  defaultButton (ok_);

  XtAddCallback (ok_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiQMsgDialog::okCallback),
		 (XtPointer)this);

  XtAddCallback (cancel_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiQMsgDialog::cancelCallback),
		 (XtPointer)this);
}

void
cmlogXuiQMsgDialog::reportErrorMsg (const char* msg)
{
  if (!dialog_) {
    dialog_ = new XcodaErrorDialog (_w, "cmlogXuiError",
				    "Error Dialog");
    dialog_->init ();
  }
  dialog_->setMessage (msg);
  dialog_->popup ();
}    

void
cmlogXuiQMsgDialog::okCallback (Widget , XtPointer data,
				XmAnyCallbackStruct *)
{
  cmlogXuiQMsgDialog* obj = (cmlogXuiQMsgDialog *)data;
  int i, j;
  int first = 1;
  int prevsel = -1;
  char msg[1024];

  for (i = 0; i < obj->numMsgs_; i++) {
    if (obj->qmsgs_[i]->active() && obj->qmsgs_[i]->queryMessage()) {
      if (first) {
	strcpy (msg, obj->qmsgs_[i]->queryMessage());
	first = 0;
      }
      else {
	// find out option dialog box associated with 
	// a previous selection kept in index prevsel
	j = obj->options_[prevsel]->currentSelection();
	strcat(msg, cmlogXuiQMsgDialog::logicOptions_[j]);
	strcat(msg, obj->qmsgs_[i]->queryMessage());
      }
      prevsel = i;
    }
  }
  if (!first)  // there are something
    XmTextFieldSetString (obj->parent_, msg);

  obj->popdown();
}

void
cmlogXuiQMsgDialog::cancelCallback (Widget , XtPointer data,
				    XmAnyCallbackStruct *)
{
  cmlogXuiQMsgDialog* obj = (cmlogXuiQMsgDialog *)data;
  obj->popdown ();
}

