//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CODA runControl Menu Bar + Menu Window
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiMenuWin.h,v $
//   Revision 1.3  2000/06/20 19:36:40  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.2  1999/11/12 17:32:08  chen
//   beta 2.0
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:44  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_MENUWIN_H
#define _CMLOG_XUI_MENUWIN_H

#include <XcodaTopLevel.h>
#include <XcodaMenuWindow.h>
#include <cmlogXuiBrowser.h>

class cmlogXuiNew;
class cmlogXuiClose;
class cmlogXuiSave;
class cmlogXuiConnect;
class cmlogXuiDisc;
class cmlogXuiDisp;
class cmlogXuiExit;
class cmlogXuiTitleBar;
class codaSepComd;
class cmlogXuiClock;
class cmlogXuiTimeWin;

// option menu
class cmlogXuiQuery;
class cmlogXuiUpdate;
class cmlogXuiRefresh;
class cmlogXuiRmAll;
class cmlogXuiSvrInfo;
class cmlogXuiConfigInfo;

// preferences menu
class cmlogXuiUbuf;
class cmlogXuiSaveSettings;
class cmlogXuiConvOption;
class cmlogXuiBlinkOption;

class cmlogXuiHelpAbout;

class cmlogXuiMenuWin: public XcodaMenuWindow
{
public:
  // constructor and destructor
  cmlogXuiMenuWin  (Widget parent, 
		    const char *name, cmlogXuiBrowser& browser);
  ~cmlogXuiMenuWin (void);

  // register top level window pointer
  void topLevelWindow (XcodaTopLevel *top);
  XcodaTopLevel* topLevelWindow (void) const;

  // change cursor
  void defineCursor (unsigned int cursor);
  void undefineCursor (void);

  // connection/disconnection configuration
  void connectionConfig (void);
  void disconnectConfig (void);
  void serverCrashConfig (void);

  // query/updating configuration
  void updatingConfig   (void);
  void queryConfig      (void);
  void normalConfig     (void);

  // update current time to the window
  void updateTime (time_t t);

  // pointer of ths display window
  cmlogXuiDisp* displayWindow (void) const;

  // setup start/end time
  void setStartTime (time_t t0);
  void setEndTime   (time_t t0);

  // set current line number under cursor
  void pointedMsgNumber (int number);

  const char* className (void) const {return "cmlogXuiMenuWin";}

protected:
  // inherited operations
  virtual Widget createMenuWindow (Widget );
  virtual void   createMenuPanes  (void);

private:
  // network handler
  cmlogXuiBrowser& browser_;

  // file menu
  cmlogXuiNew*     neww_;
  cmlogXuiClose*   close_;
  cmlogXuiSave*    save_;
  cmlogXuiConnect* connect_;
  cmlogXuiDisc*    disc_;
  codaSepComd*     sep0_;
  codaSepComd*     sep1_;
  cmlogXuiExit*    exit_;

  // options menu
  cmlogXuiRefresh* refresh_;
  cmlogXuiRmAll*   rmall_;
  cmlogXuiSvrInfo* svrinfo_;
  cmlogXuiConfigInfo* confinfo_;
  cmlogXuiConvOption* conv_;
  cmlogXuiBlinkOption* blink_;
  cmlogXuiQuery*   query_;
  cmlogXuiUpdate*  update_;

  // preference menu
  cmlogXuiUbuf* ubuf_;
  cmlogXuiSaveSettings* saves_;


  // help menu
  cmlogXuiHelpAbout* about_;

  // display window
  cmlogXuiDisp*    disp_;

  // current time (clock)
  cmlogXuiClock* clock_;

  // start/end time display window
  cmlogXuiTimeWin* twin_;

  // display title bar
  cmlogXuiTitleBar* titleBar_;

  // toplevel window that holds this menuwindow
  XcodaTopLevel*   topw_;

  // friend class 
  friend class cmlogXuiDisp;
};
#endif
