//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Server Query Message Logic Expression Parser Supporting Routines
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiLogicSup.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:34  bickley
// Added cmlog to application development system.
//
//
//
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <cmlogXuiConfig.h>
#include <cmlogXuiLogic.h>

/* internal query string */
static char*     _query_string = 0;

char*
cmlog_xui_title_match (char* title)
{
  cmlogXuiConfig* config = cmlogXuiConfig::config ();
  char* tag;

  if ((tag = config->tagOfTitle (title)) != 0)
    return tag;
  return 0;
}

void
set_cmlog_xui_qstr (char* str)
{
  if (_query_string) 
    free (_query_string);

  _query_string = cmlog_xui_strdup (str);
}

char*
cmlog_xui_strdup (char* str)
{
  char* p = (char *)malloc ((strlen (str) + 1)*sizeof (char));
  strcpy (p, str);
  return p;
}

void
set_input_text (char* input)
{
  _logic_input_text = input;
}


/* global input_text buffer */
char* _logic_input_text;

/* forward declaration of yyparse */
extern "C" int yyparse (void);

char*
cmlogXuiQueryString (char* input)
{
  set_input_text (input);

  if (yyparse ()) /* error: grammer */
    return 0;
  else 
    return _query_string;
}
