//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogXuiHADialog Class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiHADialog.cc,v $
//   Revision 1.4  2002/09/09 17:14:01  chen
//   Ready for 2.1
//
//   Revision 1.3  2000/06/20 19:36:38  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.2  2000/02/07 16:11:20  chen
//   cmlog protocol version 2.0
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.2  1997/08/26  17:23:15  chen
// change to version 1.0
//
// Revision 1.1  1997/08/01  15:31:27  bickley
// Added cmlog to application development system.
//
//
//
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/LabelG.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <XcodaXpmLabel.h>
#include <cmlogXuiHelpAbout.h>

#include "cmlogXuiHADialog.h"

#include <cmlog.xpm>

cmlogXuiHADialog::cmlogXuiHADialog (cmlogXuiHelpAbout* base,
				    const char* name,
				    const char* title)
:XcodaFormDialog (base->dialogBaseWidget (), name, title),
 base_ (base), log_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiHADialog Class Object\n");
#endif
  // empty
}

cmlogXuiHADialog::~cmlogXuiHADialog (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiHADialog Class Object\n");
#endif
  // empty
}

void
cmlogXuiHADialog::createFormChildren (void)
{
  Arg arg[20];
  int ac = 0;

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 10); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 10); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 10); ac++;
  Widget leftform = XtCreateWidget ("left_form", xmFormWidgetClass,
				    _w, arg, ac);
  ac = 0;

  log_ = new XcodaXpmLabel (leftform, "       ", (char **)cmlog_xpm);
  log_->init ();

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 10); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetValues (log_->baseWidget (), arg, ac);
  ac = 0;

  XmString t = XmStringCreateSimple ((char *)("CMLOG"));

  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, log_->baseWidget ()); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 10); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  Widget label = XtCreateManagedWidget ("label", xmLabelGadgetClass,
					leftform, arg, ac);
  ac = 0;
  XmStringFree (t);

  // create a separator
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 2); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 2); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, leftform); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 10); ac++;
  XtSetArg (arg[ac], XmNorientation, XmVERTICAL); ac++;
  Widget sep = XtCreateManagedWidget ("sep", xmSeparatorGadgetClass,
				      _w, arg, ac);
  ac = 0;


  char msg[256], vstr[128];

  ::sprintf (msg, "Motif-based CMLOG for Control Systems\n\n");
  ::sprintf (vstr, "CMLOG Version 2.1 with %s \n\n", 
	     CMLOG_PROTOCOL_VERSION_STRING);
  ::strcat  (msg, vstr);
  ::sprintf (vstr, "Developed at TJNAF, by High Performance Computing Group\n\n");
  ::strcat  (msg, vstr);
  ::sprintf (vstr, "Developed at SLAC,  with Software Control Group");
  ::strcat  (msg, vstr);

  t = XmStringCreateLtoR (msg, XmSTRING_DEFAULT_CHARSET);
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, sep) ;ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  Widget label1 = XtCreateManagedWidget ("label", xmLabelGadgetClass,
					 _w, arg, ac);
  ac = 0;
  XmStringFree (t);

  t = XmStringCreateSimple ((char *)("ok"));
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, label1); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  Widget ok = XtCreateManagedWidget ("ok", xmPushButtonGadgetClass,
				     _w, arg, ac);
  ac = 0;
  XmStringFree (t);

  XtAddCallback (ok, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiHADialog::okCallback),
		 (XtPointer)this);

  XtManageChild (leftform);
}

void
cmlogXuiHADialog::okCallback (Widget w, 
			       XtPointer data,
			       XmAnyCallbackStruct* cbs)
{
  cmlogXuiHADialog* dialog = (cmlogXuiHADialog *)data;

  dialog->popdown ();
}


  
