//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of exit command menu in the file menu
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiExit.cc,v $
//   Revision 1.2  2000/06/20 19:36:37  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:22  bickley
// Added cmlog to application development system.
//
//
//
#include <XcodaApp.h>
#include "cmlogXuiMenuWin.h"
#include "cmlogXuiTopW.h"
#include "cmlogXuiExit.h"
#include "cmlogXuiExitDialog.h"

cmlogXuiExit::cmlogXuiExit (const char* name, int active,
			    const char* acc, const char* acc_text,
			    cmlogXuiMenuWin* win,
			    cmlogXuiBrowser& browser)
:cmlogXuiMenuBtn (name, active, acc, acc_text, win, browser), dialog_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiExit Class Object\n");
#endif
}

cmlogXuiExit::~cmlogXuiExit (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiExit Class Object\n");
#endif
}

void
cmlogXuiExit::doExit (void)
{
  if (browser_.connected ())
    browser_.disconnect ();
  theApplication->cleanMemory();
}

void
cmlogXuiExit::doit (void)
{
  char temp[128];

  if (!dialog_) {
    dialog_ = new cmlogXuiExitDialog (this, (char *)("exitDialog"), 
				      (char *)("cmlog_exit_dialog"),
				       browser_);
    dialog_->init ();
    dialog_->alignment (XmALIGNMENT_CENTER);
    sprintf (temp, "Do you really want to quit ?");
    dialog_->setMessage (temp);
  }
  dialog_->popup ();
}

void
cmlogXuiExit::undoit (void)
{
  // empty
}

