//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogXuiDate class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiDate.cc,v $
//   Revision 1.3  2001/06/21 18:19:51  chen
//   Port to RedHat 7.1
//
//   Revision 1.2  2000/06/20 19:36:37  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.2  1998/10/29  18:49:50  chen
// port to RedHat 5.1
//
// Revision 1.1  1997/08/01  15:31:11  bickley
// Added cmlog to application development system.
//
//
#include <stdlib.h>
#include <cmlogConfig.h>
#include "cmlogXuiDate.h"

#ifdef __linux
extern "C"  char *strptime (const char *s, const char *fmt,
			    struct tm *tp);
#endif

cmlogMonStruct cmlogXuiDate::reg_year_struct_[] = 
{
  {1, "January", 31},
  {2, "February", 28},
  {3, "March", 31},
  {4, "April", 30},
  {5, "May", 31},
  {6, "June",30},
  {7, "July",31},
  {8, "August",31},
  {9, "September",30},
  {10, "October", 31},
  {11, "November", 30},
  {12, "December", 31},
};

cmlogMonStruct cmlogXuiDate::leap_year_struct_[] = 
{
  {1, "January", 31},
  {2, "February", 29},
  {3, "March", 31},
  {4, "April", 30},
  {5, "May", 31},
  {6, "June",30},
  {7, "July",31},
  {8, "August",31},
  {9, "September",30},
  {10, "October", 31},
  {11, "November", 30},
  {12, "December", 31},
};

int cmlogXuiDate::num_months_ = 12;

unsigned int cmlogXuiDate::base_year_ = 1900;

char* cmlogXuiDate::date_format_ = (char *)("%b %d %H:%M:%S %Y");

int
cmlogXuiDate::leap_year (unsigned int year)
{
  if (year <= 1752)
    return !(year % 4);
  else 
    return (!(year % 4) && (year % 100 || !(year % 400)));
}

cmlogXuiDate::cmlogXuiDate (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogXuiDate Class Object\n");
#endif
  reset ();
}

cmlogXuiDate::cmlogXuiDate (unsigned int year,
			    unsigned int month,
			    unsigned int day,
			    unsigned int hour,
			    unsigned int minute,
			    unsigned int second)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogXuiDate Class Object\n");
#endif
  set (year, month, day, hour, minute, second);
}

cmlogXuiDate::~cmlogXuiDate (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogXuiDate Class Object\n");
#endif
  // empty
}

int
cmlogXuiDate::set (unsigned int year,
		   unsigned int month,
		   unsigned int day,
		   unsigned int hour,
		   unsigned int minute,
		   unsigned int second)
{
  unsigned int maxdays = 0;
  year_ = year;

  // set month
  if (month < 1)
    month_ = 1;
  else if (month_ > 12)
    month_ = 12;
  else
    month_ = month;


  // set day
  if (cmlogXuiDate::leap_year (year_)) {
    maxdays = cmlogXuiDate::leap_year_struct_[month_ - 1].numdays;
    if (day < 1)
      day_ = 1;
    else if (day > maxdays)
      day_ = maxdays;
    else
      day_ = day;
  }
  else {
    maxdays = cmlogXuiDate::reg_year_struct_[month_ - 1].numdays;
    if (day < 1)
      day_ = 1;
    else if (day > maxdays)
      day_ = maxdays;
    else
      day_ = day;
  }

  // set hour
  hour_ = hour % 24;
  // set minute
  minute_ = minute % 60;
  // set seconds
  second_ = second % 60;

  return 0;
}

void
cmlogXuiDate::reset (void)
{
  struct timeval tv;
  gettimeofday (&tv, 0);

  time_t temp = (time_t) (tv.tv_sec);

  struct tm* result = localtime (&temp);

  year_ = (unsigned int)result->tm_year + cmlogXuiDate::base_year_;
  month_ = (unsigned int)result->tm_mon + 1;
  day_ = (unsigned int)result->tm_mday;
  hour_ = (unsigned int)result->tm_hour;
  minute_ = (unsigned int)result->tm_min;
  second_ = (unsigned int)result->tm_sec;
}

int
cmlogXuiDate::year (unsigned int year)
{
  return set (year, month_, day_, hour_, minute_, second_);
}

int
cmlogXuiDate::year (char* y)
{
  int temp = atoi (y);
  return year ((unsigned int)temp);
}

unsigned int
cmlogXuiDate::year (void) const
{
  return year_;
}

int
cmlogXuiDate::month (unsigned int month)
{
  return set (year_, month, day_, hour_, minute_, second_);
}

int
cmlogXuiDate::month (char* mon)
{
  int i = 0;
  unsigned int m;

  for (i = 0; i < cmlogXuiDate::num_months_; i++) {
    if (strcmp (mon, cmlogXuiDate::reg_year_struct_[i].name) == 0) {
      m = cmlogXuiDate::reg_year_struct_[i].month;
      return month (m);
    }
  }
  return -1;
}

char *
cmlogXuiDate::month (void) const
{
  int i = 0;

  char* ret = new char[strlen (cmlogXuiDate::reg_year_struct_[month_ - 1].name)
		      + 1];
  strcpy (ret, cmlogXuiDate::reg_year_struct_[month_ - 1].name);
  return ret;
}

int
cmlogXuiDate::day (unsigned int day)
{
  return set (year_, month_, day, hour_, minute_, second_);
}

unsigned int
cmlogXuiDate::day (void) const
{
  return day_;
}

int
cmlogXuiDate::hour (unsigned int hour)
{
  return set (year_, month_, day_, hour, minute_, second_);
}

unsigned int
cmlogXuiDate::hour (void) const
{
  return hour_;
}

int
cmlogXuiDate::minute (unsigned int minute)
{
  return set (year_, month_, day_, hour_, minute, second_);
}

unsigned int
cmlogXuiDate::minute (void) const
{
  return minute_;
}

int
cmlogXuiDate::second (unsigned int second)
{
  return set (year_, month_, day_, hour_, minute_, second);
}

unsigned int
cmlogXuiDate::second (void) const
{
  return second_;
}

unsigned int
cmlogXuiDate::maxDays (unsigned int month)
{
  unsigned int maxdays;

  if (cmlogXuiDate::leap_year (year_)) 
    maxdays = cmlogXuiDate::leap_year_struct_[month - 1].numdays;
  else 
    maxdays = cmlogXuiDate::reg_year_struct_[month - 1].numdays;
  
  return maxdays;
}

char* 
cmlogXuiDate::date (void)
{
  char str[128];
  char* monrep;

  monrep = (char *)month ();
  sprintf (str, "%s %d %d:%d:%d %d", monrep, day_, hour_, minute_, second_,
	   year_);
  // free memory
  delete []monrep;

  char* ret = new char[strlen (str) + 1];
  strcpy (ret, str);
  
  return ret;
}

int
cmlogXuiDate::date (double& time)
{
  int dst = -2;
  time_t t;
  struct tm tmv;

  char* strrep = (char *)date ();
  if (strptime (strrep, cmlogXuiDate::date_format_, &tmv) != NULL) {
    tmv.tm_isdst = dst;
    t = mktime (&tmv); 
    time = (double)t;
    return 0;
  }
  return -1;
}

      

