//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of connect menu in the file menu
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiConnect.cc,v $
//   Revision 1.2  2000/06/20 19:36:37  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:08  bickley
// Added cmlog to application development system.
//
//
//
#include "cmlogXuiMenuWin.h"
#include "cmlogXuiConnect.h"

cmlogXuiConnect::cmlogXuiConnect (const char* name, int active,
				  const char* acc, const char* acc_text,
				  cmlogXuiMenuWin* win,
				  cmlogXuiBrowser& browser)
:cmlogXuiMenuBtn (name, active, acc, acc_text, win, browser)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiConnect Class Object\n");
#endif
}

cmlogXuiConnect::~cmlogXuiConnect (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiConnect Class Object\n");
#endif
}

void
cmlogXuiConnect::doit (void)
{
  defineCursor (XC_watch);

  if (browser_.connected ()) 
    reportErrorMsg ((char *)("Connected to cmlogServer already"));
  else {
    if (browser_.connect () != CMLOG_SUCCESS) 
      reportErrorMsg ((char *)("Cannot connect to the cmlogServer"));
  }
  undefineCursor ();
}

void
cmlogXuiConnect::undoit (void)
{
  // empty
}

