//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Conversion utility that converts numeric codes
//      to user defined string representations
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiCodeConverter.h,v $
//   Revision 1.3  2000/12/13 16:44:14  chen
//   add action and bell
//
//   Revision 1.2  1999/11/12 17:32:01  chen
//   beta 2.0
//
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
//
//
#ifndef _CMLOG_XUI_CODE_CONVERTER_H
#define _CMLOG_XUI_CODE_CONVERTER_H

#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

class cmlogXuiCodeConverter;

class cmlogXuiCodeItem
{
private:
  cmlogXuiCodeItem  (void);
  cmlogXuiCodeItem  (long code, char* str, char* colorstr, char* desc);
  ~cmlogXuiCodeItem (void);
  cmlogXuiCodeItem  (const cmlogXuiCodeItem& item);
  cmlogXuiCodeItem& operator = (const cmlogXuiCodeItem& item);

  void parseDescription (char* desc);
  int  generateTokens   (char* desc, char sep, char** token, unsigned int num);
  
  long   code_;
  char*  str_;
  char*  colorStr_;
  char*  action_;
  Pixel  color_;
  int    blink_;
  int    bell_;


  friend class cmlogXuiCodeConverter;
};

class cmlogXuiCodeConverter
{
public:
  // constructor
  cmlogXuiCodeConverter  (int seltag, int convtag, char* seltagvalue);
  ~cmlogXuiCodeConverter (void);

  // parse input file stream 
  int input              (FILE* in);

  // output this class
  int output             (FILE* out);

  // process the table and convert color strings to pixel values
  void colorStringsToPixels    (void);

  // return selection tag
  int selectionTag       (void) const {return selTag_;}

  // return selection tag value
  char* selectionTagVal  (void) const {return seltagValue_;}

  // return convertion tag
  int conversionTag      (void) const {return convTag_;}

  // given a conversion tag and code, return correponding string and color
  int find (long code, char str[], int strsize, Pixel* color,  int* blink);

  // given a string find coressponding color
  int find (char* string, Pixel* color, int* blink);

  // check whether a converter has bell option on
  int doBell (long code);
  int doBell (char* value);

  // check whether a conveter has an action
  int hasAction (long code, char action[], unsigned int size);
  int hasAction (char* value, char action[], unsigned int size);

  // find out any code item with blink on
  int blinkOn (void) const;

protected:
  // add individual conversion to the list
  int addConversionInfo  (long code, char* str, char* color, char* desc);
  
private:
  // selection tag
  int selTag_;

  // conversion tag
  int convTag_;

  // corresponding char string value for selected tag
  char* seltagValue_;

  // array to hold all information
  cmlogXuiCodeItem*     item_;
  int                   size_;
  int                   bufsize_;
};
#endif

  
