//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implmentation of cmlog xui close dialog
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiCloseDialog.cc,v $
//   Revision 1.2  2000/06/20 19:36:36  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:02  bickley
// Added cmlog to application development system.
//
//
//
#include <cmlogXuiClose.h>
#include "cmlogXuiCloseDialog.h"

cmlogXuiCloseDialog::cmlogXuiCloseDialog (cmlogXuiClose* close, 
					  const char* name,
					  const char *title, 
					  cmlogXuiBrowser& handler)
:XcodaWarningDialog (close->dialogBaseWidget(), name, title), close_ (close),
 browser_ (handler)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Create cmlogXuiCloseDialog Class Object\n");
#endif
  // empty
}

cmlogXuiCloseDialog::~cmlogXuiCloseDialog (void)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Delete cmlogXuiCloseDialog Class Object\n");
#endif
  // empty
}

void
cmlogXuiCloseDialog::ok (void)
{
  close_->doClose ();
}
