//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog xui clock display
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiClock.h,v $
//   Revision 1.2  2000/06/20 19:36:36  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:30:58  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_CLOCK_H
#define _CMLOG_XUI_CLOCK_H

#include <stdio.h>
#include <string.h>
#include <XcodaUi.h>
#include <cmlogXuiBrowser.h>

class cmlogXuiMenuWin;

class cmlogXuiClock: public XcodaUi
{
public:
  // constructor and destructor
  cmlogXuiClock  (Widget parent, const char* name,
		  cmlogXuiMenuWin* win,
		  cmlogXuiBrowser& browser);
  ~cmlogXuiClock (void);

  // create widget and etc
  void  init (void);

  // display current time
  void  display (time_t time);

  const char* className (void) const {return "cmlogXuiClock";}

private:

  // data area
  Widget parent_;
  // Label widget
  Widget label_;
  // _w will be a frame widget

  // menu window
  cmlogXuiMenuWin* window_;
  
  // network handler
  cmlogXuiBrowser& browser_;
};
#endif

  
