//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Main Part of cmlog
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlog.cc,v $
//   Revision 1.5  2002/09/09 17:14:01  chen
//   Ready for 2.1
//
//   Revision 1.4  2000/06/20 19:36:36  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.3  2000/02/07 16:11:19  chen
//   cmlog protocol version 2.0
//
//   Revision 1.2  1999/10/29 17:40:05  chen
//   support spaces and quotes in cmlogrc file
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.3  1998/11/19  17:37:21  chen
// cmlog 1.1 version
//
// Revision 1.2  1997/08/26  17:23:14  chen
// change to version 1.0
//
// Revision 1.1  1997/08/01  15:30:52  bickley
// Added cmlog to application development system.
//
//
//
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <XcodaApp.h>
#include <cmlogXuiBrowser.h>
#include <cmlogXuiTopW.h>
#include <cmlogXuiConfig.h>

static const char* fallback_resources[] =
{
  "cmlog.*.fontList: -*-helvetica-medium-r-*-*-14-*-*-*-*-*-*-*",
  "cmlog.*.font: -*-helvetica-medium-r-*-*-14-*-*-*-*-*-*-*",
  "cmlog.*.menu_bar.*.fontList: -*-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*",
  "cmlog.*.titleBar.font: -*-times-bold-i-*-*-14-*-*-*-*-*-*-*",
  "cmlog.*.XmToggleButtonGadget.selectColor:     red",
  "cmlog.*.XmToggleButton.selectColor:     red",
  "cmlog.*.background: lightgrey",
  "cmlog.*.foreground: black",
  "cmlog.*.highlightThickness: 0",
  "cmlog.*.XmArrowButtonGadget.width: 14",
  "cmlog.*.XmArrowButtonGadget.height: 14",
  "cmlog.*.XmArrowButtonGadget.shadowThickness: 0",
  "cmlog.*.XmArrowButtonGadget.borderWidth: 0",
  "cmlog.*.altForeground: red",
  "cmlog.*.altForeground1: brown",
  "cmlog.*.altForeground2: blue",
  "cmlog.*.altForeground3: lightblue",
  "cmlog.*.altForeground4: steelblue",
  "cmlog.*.altForeground5: cyan",
  "cmlog.*.altForeground6: pink",
  "cmlog.*.altForeground7: yellow",
  NULL
};


main (int argc, char** argv)
{
  printf ("cmlog browser with %s\n", CMLOG_PROTOCOL_VERSION_STRING);
  char title[128];

  XcodaApp* app = new XcodaApp (argv[0], fallback_resources);
  // open a X display
  app->open (&argc, argv);

  // create a network handler which register itself to x window
  // event loop
  cmlogXuiBrowser browser(app->appContext ());

  // create cmlogConfig
  cmlogXuiConfig* config = cmlogXuiConfig::config ();
  config->init (argc, argv);

  if (config->configName())
    sprintf (title, "%s      CMLOG Version 2.1", config->configName());
  else
    strcpy (title, "CMLOG Version 2.1");

  // create top level window
  // last argument to denote that this browser should not be deleted 
  // upon exit the window
  cmlogXuiTopW* window  = new cmlogXuiTopW (title, &browser, 0);
  
  app->initialize (&argc, argv);

  // setup timer
  browser.auto_arm (1000);

  app->execute ();

  // never get here
  return 0;
}

