// Test program for thread manager

#include "cpThread.h"
#include "cpThreadManager.h"

static  int  interrupted = 0;

static void signalHandler (int signo)
{
  printf ("get signal %d\n", signo);
  interrupted = 1;
}

static void cleanup (void* arg)
{
  printf ("Cleanup handler get called\n");
}

static int
reader (cpThreadManager* manager)
{
 cpThreadControl control (manager);

 cpThread::add_cleanup_handler (cleanup, 0);

  int i = 0;
  int loop = 100;
  while (i < loop) {
    // printf ("Loop from thread %d ====> %d\n",cpThread::self(), i);
    i++;
    taskDelay (2*sysClkRateGet ());
  }
  return 0;
}

static int signals[] =
{SIGINT, SIGQUIT, SIGILL, SIGFPE,
 SIGPIPE, SIGQUIT,
 SIGTERM, SIGTSTP, SIGCONT};

static int numSignals = 9;

tmTest (int n_threads, int loop)

{
  cpThreadManager manager0;

  int grpid = manager0.spawn_n (n_threads, CP_THREAD_FUNC (reader),
				(void *)&manager0);

  printf ("Group id is %d\n", grpid);

  struct sigaction act, oact;
  act.sa_handler = signalHandler;
  act.sa_flags = 0;
  sigemptyset (&act.sa_mask);

  for (int i = 0; i < numSignals; i++)
    sigaction (signals[i], &act, &oact);


  manager0.wait (); // wait for all task to finish

  printf ("End of all tasks\n");

  interrupted = 0;
}


  
