//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog server signal handler
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogSignalHandler.h,v $
//   Revision 1.2  2000/03/01 17:09:32  chen
//   Add concurrency control and output signa info to a file
//
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:30:05  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_SIGNAL_HANDLER_H
#define _CMLOG_SIGNAL_HANDLER_H

#include <cmlogConfig.h>

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)

// no need ACE stuff here
#define _CMLOG_BUILD_CLIENT
#include <cmlogMsg.h>
#undef _CMLOG_BUILD_CLIENT

#include <cpThreadManager.h>

extern cpThreadManager manager;
#else
#include <cpProcessManager.h>
extern cpProcessManager manager;
#endif

extern sig_atomic_t finished;

class cmlogSignalHandler
{
public:
  // operation
  static int registerSignalHandlers (void);

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  // wait for signals
  static void* signalFunc   (void* arg);
  static sigset_t sig_set;
#else 
  // all signal handlers 
  static void  signalFunc   (int signo);
#endif

private:
  // all signals we want to catch
  static int signals[];
  static int numSignals;
  static FILE* siginfofile_;
  // deny direct access
  cmlogSignalHandler (void);
};
#endif

  

