//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog server processing service
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogService.cc,v $
//   Revision 1.3  2001/07/25 14:30:47  chen
//   64 BIT Initial Port
//
//   Revision 1.2  2001/07/03 17:24:05  chen
//   Remove some unused code
//
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.3  1998/10/07  17:03:34  chen
// Fix a compiler (egcs) warning about cmlog_cdevMessage& = (cmlog_cdevMessage)
//
// Revision 1.2  1997/12/11  18:15:02  chen
// fix a bug under multi-threaded situation
//
// Revision 1.1  1997/08/01  15:30:00  bickley
// Added cmlog to application development system.
//
//
#include <cmlogUtil.h>
#include <cdevData.h>
#include <cmlog_cdevTagMap.h>
#include <cmlogMsg.h>
#include <cmlogBrowserIO.h>
#include <cmlogDatabase.h>
#include <cmlogDataCache.h>
#include <cmlogCxtDataCache.h>
#include <cmlogLogicSup.h>
#include "cmlogService.h"

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)

extern sig_atomic_t    finished;

inline int cmlogSvcTestClean (cmlogBrowserIO* channel)
{
  if (!channel->connected ()) {
    channel->cleanup ();
    return 1;
  }
  return 0;
}

void *
cmlogService::serviceThread (void *arg)
{
  cmlogService *obj = (cmlogService *)arg;

  for (;;) {
    obj->process ();
  }
  return 0;
}
#endif

cmlogService::cmlogService (cmlogDataQueue* queue, 
			    cmlogDatabase* dbase,
			    cmlogDatabase* cxtdbase)
:queue_ (queue), dbase_ (dbase), cxtdbase_ (cxtdbase), cache_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogService Class Object\n");
#endif
  // empty
}

cmlogService::cmlogService (void)
:queue_ (0), dbase_ (0), cxtdbase_ (0), cache_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogService Class Object\n");
#endif
  // empty
}

cmlogService::~cmlogService (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogService Class Object\n");
#endif
  // empty
}

void
cmlogService::dataQueue (cmlogDataQueue* queue)
{
  queue_ = queue;
}

void
cmlogService::database (cmlogDatabase* dbase)
{
  dbase_ = dbase;
}

void
cmlogService::cxtdatabase (cmlogDatabase* cxtdbase)
{
  cxtdbase_ = cxtdbase;
}

void
cmlogService::dataCache (cmlogDataCache* cache)
{
  cache_ = cache;
}


void
cmlogService::process (void)
{
  cmlogMsg* msg = (cmlogMsg *)queue_->dequeue ();

#if !defined (CMLOG_USE_THREAD) || !defined (_REENTRANT)
  if (!msg)
    return;
#endif

  int value;
  double key;
  cmlog_cdevMessage& data = (*msg);

  switch (msg->type ()) {
  case CMLOG_ADD_DATA:
    {
      cdevData* d = data.getData ();
      
      if (d->get (cmlogUtil::CMLOG_KEY_TAG, &key) != CDEV_SUCCESS) {
	// in case client side has no time stamp capability
	key = cmlogUtil::currentTime ();
	d->insert (cmlogUtil::CMLOG_KEY_TAG, key);
      }
      dbase_->put (*d);
      // put this data into data cache
      // cdevData* newd = new cdevData (*d);
      // cache_->add ((void *)newd);
    }
    break;
  case CMLOG_CONN_INFO:
  case CMLOG_RECONN_INFO:
    {
      cdevData* d = data.getData ();
      // it is possible that d is empty since context is empty
      if (d) {
	if (d->get (cmlogUtil::CMLOG_KEY_TAG, &key) != CDEV_SUCCESS) {
	  key = cmlogUtil::currentTime ();
	  d->insert (cmlogUtil::CMLOG_KEY_TAG, key);
	}
	cxtdbase_->put (*d);
	// context database is small, so just flush it
	cxtdbase_->flush ();
      }
    }
    break;
  case CMLOG_ADD_CXT:
    {
      cdevData* d = data.getData ();
      if (d->get (cmlogUtil::CMLOG_KEY_TAG, &key) != CDEV_SUCCESS) {
	key = cmlogUtil::currentTime ();
	d->insert (cmlogUtil::CMLOG_KEY_TAG, key);
      }
      cxtdbase_->put (*d);
      // context database is small, so just flush it
      cxtdbase_->flush ();
    }
    break;
  case CMLOG_FIND_DATA:
    cmlogUtil::serverPrintf ("Error>>>>>Find data should never be called\n");
    break;
  case CMLOG_TAGMAP:
    cmlogUtil::serverPrintf ("Error>>>>>CMLOG_TAGMAP should never be called\n");
    break;
  case CMLOG_EXIT:
    dbase_->flush ();
    dbase_->close ();

    cxtdbase_->flush ();
    cxtdbase_->close ();
    delete msg;
    
    finished = 1;
    cmlogUtil::serverPrintf ("Server shutdown by admin task\n");
    
    ::exit (0);
    break;
  default:
    cmlogUtil::serverPrintf ("Error>>>>>> Unknown Msg type is %d\n", msg->type ());
    break;
  }
  delete msg;
}
