//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog server utilties
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogServerAux.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:58  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_SERVER_AUX_H
#define _CMLOG_SERVER_AUX_H

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>

#include <cmlogConfig.h>

class cmlogServerAux
{
public:
  // handle several necessary routines before starting the server
  static void auxiliaryHandlers (void);

protected:
  // close controlling tty
  static void closeCtrlTTY (void);
  // move server to predefined directory if necessary
  static void moveToDefaultDirectory (void);
  // restrict file creation previlige
  static void setUMask (void);
  // set process group
  static void setProcessGrp (void);
  // setup log file if possible
  static void setLogFile (void);
  // record process id
  static void recordProcessId (void);

private:
  // deny access
  cmlogServerAux (void);

};

#endif
