//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog server query thread (process)
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogQuerySvc.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
//
//
#ifndef _CMLOG_QUERY_THREAD_H
#define _CMLOG_QUERY_THREAD_H

#include <stdio.h>
#include <string.h>
#include <cmlogConfig.h>

class cmlogMsg;
class cmlog_cdevMessage;
class cmlogPacket;
class cmlogBrowserIO;
class cmlogDatabase;
class cdevData;

class cmlogQuerySvc
{
public:
  // constructor
  cmlogQuerySvc  (cmlogBrowserIO* io, cmlogMsg* msg);
  // destructor
  ~cmlogQuerySvc (void);

  // stop this query process
  // this method is called from the main thread
  void abort    (void);

  // check whether this query service is aborted
  // two reasons of being aborted: 1. browser is closed by
  // remote browser, 2. browser tries to abort this query
  // before finishing query
  int  aborted  (void);

  // return this query query id
  unsigned queryId (void) const {return qid_;}
  
  // return callback id of this query
  unsigned callbackId (void) const {return cbkid_;}

#if !defined (CMLOG_USE_THREAD) || !defined (_REENTRANT)
  void     queryProcessId (pid_t id);
  pid_t    queryProcessId (void) const;
#endif

  // method to spawn a thread
  static void* querySvcThread (void* arg);

protected:
  // find data from database
  void findData (cmlog_cdevMessage* message,
		 cmlogDatabase* dbase, cmlogDatabase* cxtdbase);

  // construct a cmlogPacket
  void constructPacket (cmlogPacket* packet, cmlog_cdevMessage* message,
			cdevData* data, int errcode);
  // flush a packet
  void flushPacket     (cmlogPacket* packet, cmlog_cdevMessage* message,
			double timestamp,
			int errcode);

private:
  // io channel for this query
  cmlogBrowserIO* io_;
  // query message (data)
  cmlogMsg*       msg_;

  // query and callback ids for quick access
  unsigned        qid_;
  unsigned        cbkid_;

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  // flag to signal to finish query
  int             aborted_;
#else
  // flag to signal to finish query
  static int      aborted_;

  // query svc process id
  pid_t           proc_;

  // all signals we want to catch
  static int signals[];
  static int numSignals;

  // register signal handler
  static int registerSignalHandlers (void);
  // all signal handlers 
  static void  signalFunc           (int signo);
#endif

  // deny copy and assignment operations of this class
  cmlogQuerySvc (const cmlogQuerySvc& svc);
  cmlogQuerySvc& operator = (const cmlogQuerySvc& svc);
};
#endif
  
  
