//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogUpAcceptor Class (UP stands for Unix Process)
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogUpAcceptor.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:23  bickley
// Added cmlog to application development system.
//
//
#include "cmlogUpAcceptor.h"
#include <cmlogUpIO.h>

cmlogUpAcceptor::cmlogUpAcceptor (ACE_Reactor& reactor, 
				  cmlogPacket& buffer,
				  cmlogUxToServer& toServer)
:r_ (reactor), buffer_ (buffer), toServer_ (toServer), upAcceptor_ (),
 connList_ ()
{
#ifdef _TRACE_OBJECTS
  printf("Create cmlogUpAcceptor Class Object\n");
#endif
  // create unique file path for unix socket
  ::strncpy (upSocketPath_, CMLOG_UNIX_SOCKET, sizeof (upSocketPath_));
  ::mktemp  (upSocketPath_);
#ifdef _CMLOG_DEBUG
  printf    ("File path for unix socket is %s\n", upSocketPath_);
#endif
}

cmlogUpAcceptor::~cmlogUpAcceptor (void)
{
#ifdef _TRACE_OBJECTS
  printf("Delete cmlogUpAcceptor Class Object\n");
#endif
  handle_close (-1, ACE_Event_Handler::READ_MASK);
}

int
cmlogUpAcceptor::handle_close (int, ACE_Reactor_Mask)
{
  cmlogSlistIterator ite (connList_);
  cmlogUpIO* upio = 0;

  for (ite.init (); !ite; ++ite) {
    upio = (cmlogUpIO *) ite ();
    r_.remove_handler (upio, ACE_Event_Handler::READ_MASK);
    delete upio;
  }
  upAcceptor_.close ();
  // remove unix socket file
  ::unlink (upSocketPath_);
  return 0;
}

int
cmlogUpAcceptor::open (void)
{
  ACE_UNIX_Addr addr (upSocketPath_);

  if (upAcceptor_.open (addr) == -1)
    return -1;
  else
    return 0;
}

char*
cmlogUpAcceptor::socketPath (void)
{
  return upSocketPath_;
}

int
cmlogUpAcceptor::numberOfConnections (void)
{
  return connList_.count ();
}

int
cmlogUpAcceptor::remove (cmlogUpIO* conn)
{
  return connList_.remove ((void *)conn);
}

int
cmlogUpAcceptor::get_handle (void) const
{
  return upAcceptor_.get_handle ();
}

cmlogSlist&
cmlogUpAcceptor::connectionList (void)
{
  return connList_;
}

int
cmlogUpAcceptor::handle_input (int)
{
  ACE_UNIX_Addr    sa;
  int          n;
  cmlogUpIO*   conn = new cmlogUpIO (r_, toServer_);

  int handle = upAcceptor_.accept (*conn, &sa);
  if (handle != -1) {
#ifdef _CMLOG_DEBUG
    printf ("Accept a unix process connection\n");
#endif
    int alive = 1;
    conn->setSockOption (SOL_SOCKET, SO_KEEPALIVE, 
			 (void *)&alive, sizeof (alive));
    if (r_.register_handler (conn, ACE_Event_Handler::READ_MASK) == -1){
      fprintf (stderr, "Cannot register Unix Process Handler\n");
      return -1;
    }
    // register this acceptor to unix process handler
    conn->manager (this);
    // add this handler to the connected service list
    connList_.add ((void *)conn);
  }
  else
    return -1;
  return 0;
}
