//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG unix/vxworks client's server heart beat monitor +
//      User process id assignment operation
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogServerHB.h,v $
//   Revision 1.2  2000/03/06 18:37:58  chen
//   Change unsigned short to short for clientid_
//
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:21  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_SERVER_HB_H
#define _CMLOG_SERVER_HB_H

#include <cmlogProtocol.h>
#include <ace/INET_Addr.h>
#include <ace/SOCK_Dgram.h>
#include <ace/Reactor.h>
#include <cmlogSlist.h>

#ifdef __vxworks
#include <cpSynch.h>
#endif

class cmlogServerHB;

class cmlogClientId
{
public:
  // constructor and destructor
  cmlogClientId  (short clientId, int procid, 
		  cdevData& cxt, cdevData& tagmap);
  ~cmlogClientId (void);

  short      clientId   (void) const;
  int        procId     (void) const;
  cdevData&  context    (void);
  cdevData&  tagmap     (void);

private:
  short      id_;
  int        pid_;
  cdevData   cxt_;
  cdevData   tagmap_;

  // friend class
  friend class cmlogServerHB;

  // deny copy and assignment operations
  cmlogClientId (const cmlogClientId &);
  cmlogClientId & operator = (const cmlogClientId &);
};

class cmlogUxToServer;

class cmlogServerHB: public ACE_Event_Handler
{
public:
  // constructor and destructor
  cmlogServerHB  (ACE_Reactor& reactor);
  ~cmlogServerHB (void);

  // open an udp socket at a well known port
  int open       (void);

  // register a timer to reconnect to the server
  int         registerMonTimer (int delay, int period);

  // all following code will be called with lock held in vxWorks

  // return client id directly
  short clientId        (void);

  // register client information
  void        registerClient     (int procid, short clientid, 
				  cdevData& cxt, cdevData& tagmap);
  // remove a client
  void        removeClient       (short clientid);

  // check all clients
  void        checkAllClients    (void);

  
  // setup unix client to server pointer
  void tcpToServer (cmlogUxToServer* toServer);

protected:
  // all inherited operations
  virtual int get_handle      (void) const;
  virtual int handle_input    (int);
  virtual int handle_close    (int, ACE_Reactor_Mask);
  virtual int handle_timeout  (const ACE_Time_Value&, const void* arg = 0);
  
  // send client id information back to user process
  void        sendClientIdToUser (ACE_INET_Addr& addr);

  // send no connection information back to yser process
  void        sendNoConnToUser   (ACE_INET_Addr& addr);

  // send disconnect information for a particular dead client
  void        sendDisconnInfo    (short clientid);

  // send connection information upon reconnection
  void        sendConnectionInfo (void);

  // open the named pipe to send disconnection information
  int         openNamedPipe      (void);

  // server heart beat threshold
  static int  serverHBTh;

private:
  // data area
  ACE_Reactor& reactor_;
  // UDP socket listening to the server
  ACE_SOCK_Dgram   listener_;
  
  // server heart beat
  int          serverHB_;
  int          timerOn_;

  // pointer of TCP connection to server
  cmlogUxToServer* toServer_;

  // client id assignment
  short        clientId_;

  // linked list of all connected clients
  cmlogSlist            clientList_;

  // deny access to copy and assignment operation
  cmlogServerHB (const cmlogServerHB &);
  cmlogServerHB& operator = (const cmlogServerHB &);
};

#ifdef __vxworks
extern char*         cmlogServerHBSymVx_;

extern "C" short cmlogVxClientId (void);
#endif

#endif
