//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Service processes' notification class
//
//      All processes that process requests send result back to
//      the main process via a pipe
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogResNotification.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:18  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_RES_NOTIFICATION_H
#define _CMLOG_RES_NOTIFICATION_H

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdlib.h>
#include <unistd.h>
#include <ace/Reactor.h>
#include <ace/Event_Handler.h>

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
class cmlogDataQueue;

class cmlogResNotification: public ACE_Event_Handler
{
public:
  cmlogResNotification  (void);
  ~cmlogResNotification (void);

  // operations
  // return internal file descriptors
  operator int* (void);


  void     dataqueue (cmlogDataQueue* queue);

protected:
  // all inherited operations
  virtual int get_handle   (void) const;
  // handle close 
  virtual int handle_close (int, ACE_Reactor_Mask);
  // handle input
  virtual int handle_input (int);

  // open a unix socket pair
  static int s_pipe (int* fds);

private:
  // file descriptors for a pipe
  int          cfds_[2];

  cmlogDataQueue* queue_;
};
#endif

#endif
