//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog Port Handler (UDP Service)
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogPortHandler.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.2  1998/02/23  19:14:46  chen
// move get_handle to public
//
// Revision 1.1  1997/08/01  15:29:15  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_PORT_HANDLER_H
#define _CMLOG_PORT_HANDLER_H

#include <cmlogProtocol.h>
#include <ace/INET_Addr.h>
#include <ace/SOCK_Dgram.h>
#include <ace/Reactor.h>

class cmlogPortHandler: public ACE_Event_Handler
{
public:
  // constructor and destructor

  // construct a port handler with argument of primary or secondary
  // server on the net. Default is primary server
  cmlogPortHandler  (ACE_Reactor& r, int primary = 1);
  
  // destructor
  ~cmlogPortHandler (void);

  // return file descritptor
  virtual int get_handle   (void) const;

  // setup client acceptor port number
  void clientAcceptorPort (unsigned short portnum);

  // setup browser acceptor port number
  void browserAcceptorPort (unsigned short portnum);

  // setup admin acceptor port number
  void adminAcceptorPort (unsigned short portnum);

  // open broadcast listener port
  int open (int async = 0);

  // return port number of this udp service
  unsigned short port_number (void);

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  static void* portHandlerThread (void *arg);
#endif  
  
protected:
  // send back reply ro the client who ask the server location
  // return 0: success
  int svcReply (ACE_INET_Addr& reqAddr, unsigned short port);

private:
  // all inherited operations
  virtual int handle_input (int fd);
  virtual int handle_close (int fd, ACE_Reactor_Mask);

  // data area
  ACE_Reactor&       reactor_;
  ACE_SOCK_Dgram     brdcastListener_;
  // port number of TCP port for client to connect
  unsigned short     clientAcceptorPort_;
  // port number of TCP port for browser to connect
  unsigned short     browserAcceptorPort_;
  // port number of TCP port for admin to connect
  unsigned short     adminAcceptorPort_;
  // flag of primary server
  int                primary_;
};
#endif
