//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG client connection context class
//
//      This class is keyed by connection time, and retrieved
//      from a list by client id which is assigned by client
//      concentrater
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogClntCxt.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:01  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_CLNTCXT_H
#define _CMLOG_CLNTCXT_H

#include <stdio.h>
#include <string.h>
#include <cmlogConfig.h>
#include <cdevData.h>

class cmlogClntCxt
{
public:
  // constructor: incoming cdevData + client id + connection time
  cmlogClntCxt  (cdevData& data, short clientId, double connectionTime);
  ~cmlogClntCxt (void);

  // check this cmlogClntCxt has the same client id. return 1: true
  int sameClient (int client) const;

  // return connection time
  double connectionTime (void) const;

  // return internal cdevData
  cdevData&  cxtData    (void);

private:
  // cdevData for context
  cdevData data_;
  // client id
  short    clientId_;
  // connection time
  double   connectionTime_;

  // deny access to copy and assignment operation
  cmlogClntCxt (const cmlogClntCxt& cxt);
  cmlogClntCxt& operator = (const cmlogClntCxt& cxt);
};
#endif
