//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG client connection context class
//
//      This class is keyed by connection time, and retrieved
//      from a list by client id which is assigned by client
//      concentrater
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogClntCxt.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:28:59  bickley
// Added cmlog to application development system.
//
//
#include <cmlogUtil.h>
#include "cmlogClntCxt.h"

cmlogClntCxt::cmlogClntCxt (cdevData& data,
			    short clientId, 
			    double connectionTime)
:data_ (data), clientId_ (clientId), connectionTime_ (connectionTime)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogClntCxt Class Object\n");
#endif
  data_.insert (cmlogUtil::CMLOG_CLNTID_TAG, clientId_);
  data_.insert (cmlogUtil::CMLOG_KEY_TAG,    connectionTime_);
}

cmlogClntCxt::~cmlogClntCxt (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogClntCxt Class Object\n");
#endif
  // empty
}

cdevData&
cmlogClntCxt::cxtData (void)
{
  return data_;
}

int
cmlogClntCxt::sameClient (int client) const
{
  return (clientId_ == client);
}

double
cmlogClntCxt::connectionTime (void) const
{
  return connectionTime_;
}
