//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog server/browser IO handler
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogBrowserIO.h,v $
//   Revision 1.2  1999/12/13 15:17:34  chen
//   Add robust check on all incoming messages
//
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:28:50  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_BROWSER_IO_H
#define _CMLOG_BROWSER_IO_H

#include <cmlogIO.h>
#include <cmlog_cdevMessage.h>
#include <cmlogMsg.h>
#include <cmlog_cdevTagMap.h>
#include <cmlogQueryManager.h>

class cmlogDatabase;

class cmlogBrowserIO: public cmlogIO
{
public:
  // constructor and destrcutor
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cmlogBrowserIO  (ACE_Reactor& r, 
		   cmlogDataQueue* queue,
		   cmlogDatabase* database,
		   cmlogDatabase* cxtdbase);
#else
  cmlogBrowserIO  (ACE_Reactor& r, 
		   cmlogDataQueue* queue,
		   cmlogDataQueue* comdq,
		   cmlogDatabase* database,
		   cmlogDatabase* cxtdbase);
#endif

  ~cmlogBrowserIO (void);


  // return tagmap pointer: just a pointer caller should not free it
  cmlog_cdevTagMap* tagmap (void);

  // convert data using local tag map
  void        convertDataLToR (cdevData& data);

  // return query manager
  cmlogQueryManager& queryManager (void) {return queryManager_;}

  // return database pointers
  cmlogDatabase* dbase (void) const {return dbase_;}
  cmlogDatabase* cxtdbase (void) const {return cxtdbase_;}

protected:
  // inherited operation for handle_input
  virtual int handle_input (int fd);

  // inherited operation for handle_close
  virtual int handle_close (int fd, ACE_Reactor_Mask);

  // real data processing routine
  int         reader       (void);

  // process cmlogPacket
  int         processData  (cmlogPacket& packet);

  // set tag map
  void        setTagMap    (cdevData* tagmap);

  // process incoming data with tag map
  void        processDataWithTagMap (cdevData* data);

private:
  // internal tag map
  cmlog_cdevTagMap  map_;

  // query manager
  cmlogQueryManager queryManager_;

  // database reference
  cmlogDatabase* dbase_;
  cmlogDatabase* cxtdbase_;

  // additional information
  char* username_;
  char* displayname_;
  long  taskid_;

  // deny access to copy and assignment operator
  cmlogBrowserIO (const cmlogBrowserIO &io);
  cmlogBrowserIO& operator = (const cmlogBrowserIO &);
};

#endif
