//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog Server Admin Connection Acceptor
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogAdminAcceptor.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:28:38  bickley
// Added cmlog to application development system.
//
//
#include <cmlogUtil.h>
#include <cmlogClientAcceptor.h>
#include <cmlogBrowserAcceptor.h>
#include "cmlogAdminAcceptor.h"
#include "cmlogAdminIO.h"

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
cmlogAdminAcceptor::cmlogAdminAcceptor (ACE_Reactor& r, 
					cmlogDataQueue* q)
:cmlogAcceptor (r, q), clientM_ (0), browserM_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogAdminAcceptor Class Object\n");
#endif
}
#else
cmlogAdminAcceptor::cmlogAdminAcceptor (ACE_Reactor& r, 
					cmlogDataQueue* q,
					cmlogDataQueue* cq)
:cmlogAcceptor (r, q, cq), clientM_ (0), browserM_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogAdminAcceptor Class Object\n");
#endif
}
#endif

cmlogAdminAcceptor::~cmlogAdminAcceptor (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogAdminAcceptor Class Object\n");
#endif
}

int
cmlogAdminAcceptor::handle_input (int)
{
  ACE_INET_Addr    rem_addr;
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cmlogAdminIO  *adm = new cmlogAdminIO (reactor_, dataQueue_);
#else
  cmlogAdminIO  *adm = new cmlogAdminIO (reactor_, dataQueue_, cmdQueue_);
#endif

  // accept the connection from a browser
  if (listener_.accept (*adm, &rem_addr) != -1){
#ifdef _CMLOG_DEBUG
    printf ("Received admin connection from host %s at port %d\n",
	    rem_addr.get_host_name (), adm->get_handle ());
#endif
    // remeber client address
    adm->peerAddr (rem_addr);
    // set socket options to KEEP_ALIVE
    int alive = 1;
    adm->setSockOption (SOL_SOCKET, SO_KEEPALIVE,
			(void *)&alive, sizeof (alive));

    // set socket into non block socket
    adm->disable (ACE_NONBLOCK);

    if (reactor_.register_handler (adm,
				   ACE_Event_Handler::READ_MASK) == -1) {
#ifdef _CMLOG_DEBUG
      printf ("Unable to register cmlogAdminIO handler\n");
#endif
      return -1;
    }
    // register this acceptor to admin IO
    adm->manager (this);
    // add this client TCP connection to the list
    connectionList_.add ((void *)adm);
  }
  else {
#ifdef _CMLOG_DEBUG
    printf ("Accept failed\n");
#endif
    return -1;
  }
  return 0;
}

void
cmlogAdminAcceptor::clientManager (cmlogClientAcceptor* ca)
{
  clientM_ = ca;
}

void
cmlogAdminAcceptor::browserManager (cmlogBrowserAcceptor* ba)
{
  browserM_ = ba;
}

void
cmlogAdminAcceptor::shutdownAllClientD (void)
{
  cdevData unused;

  if (clientM_) 
    clientM_->sendToAllConnections (CMLOG_EXIT, unused);
}

