//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Generic cmlog TCP connection acceptor
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogAcceptor.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:28:37  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_ACCEPTOR_H
#define _CMLOG_ACCEPTOR_H

#include <ace/INET_Addr.h>
#include <ace/SOCK_Acceptor.h>
#include <ace/Reactor.h>
#include <cmlogProtocol.h>
#include <cdevData.h>
#include <cmlogSlist.h>
#include <cmlogDataQueue.h>

class cmlogIO;

class cmlogAcceptor: public ACE_Event_Handler
{
public:
  // destructor
  virtual ~cmlogAcceptor (void);

  // open local address
  int open (void);
  // return number of IO connection
  int numberConnections (void);
  // remove a connection from the list
  int remove (cmlogIO* con);
  // check whether cmlogIO in in the list
  int includes (cmlogIO* con);

  // set socket options
  int setSockOption (int level, int option, void* optval, int optlen) const;
  
  // send a result to all clients
  void sendToAllConnections (int command, cdevData& data, long id = 0);

  // return port number
  unsigned short port_number (void);

  // return client list
  cmlogSlist& connectionList (void);

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  static void* acceptorThread (void *arg);
#endif

protected:
  // constructor to deny direct instantiation
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cmlogAcceptor          (ACE_Reactor& r, cmlogDataQueue* dataqueue = 0);
#else
  cmlogAcceptor          (ACE_Reactor& r, cmlogDataQueue* dataqueue = 0,
			  cmlogDataQueue* commandQueue = 0);
#endif

  // inherited operations
  virtual int get_handle   (void) const;
  virtual int handle_close (int fd, ACE_Reactor_Mask);

  // delete all clients : only used in the destructor
  void deleteAllConnections    (void);

  // data areas
  ACE_SOCK_Acceptor listener_;
  ACE_Reactor&      reactor_;
  cmlogSlist        connectionList_;
  cmlogDataQueue*   dataQueue_;
#if !defined (CMLOG_USE_THREAD) || !defined (_REENTRANT)
  cmlogDataQueue*   cmdQueue_;
#endif
};

#endif
