// test program for logging client
#include <cmlogClient.h>
#include <unistd.h>

#ifdef __vxworks
extern "C" int clientTest (char* name);
#endif

#ifndef __vxworks
main (int argc, char** argv)
#else
clientTest (char* name)
#endif
{
  int status;
#ifndef __vxworks
  struct timeval itv, ftv;
  cmlogClient *client = new cmlogClient (argv[0]);
#else
  struct timespec itv, ftv;
  cmlogClient *client = cmlogClient::logClient ();
#endif

  if (client->connect () == CMLOG_SUCCESS) {
    cdevData::insertTag (238, "myTag");
    cdevData::insertTag (322, "highVIn");
    cdevData::insertTag (323, "highVOut");
    cdevData::insertTag (324, "text");
  }

    
  // client->setThrottle ("highVIn", 100, 25, 1.0);

  char temp[80];
#ifndef __vxworks
  gettimeofday (&itv, 0);
#else
  clock_gettime (CLOCK_REALTIME, &itv);
#endif

  cdevData data;
  int i;
  
  for (i = 0; i < 86400; i++) {
    sprintf (temp, "New error message happend at %d\n", i);
    
    status = client->postError (i%20, i%20, i%90, 
				"CODA", "status = %d highVIn = %d highVOut = %d text = %s", 1,
			       i, i*100, temp);
    // printf ("%s", temp);
#ifndef __vxworks
    sleep (1); 
#else
    taskDelay (sysClkRateGet ());
#endif
  }


  for (i = 0; i < 2000; i++) {
    sprintf (temp, "Same error message happend at %d\n", i*10);
    
    status = client->postError (43, 12, CMLOG_ERROR, 
			       "CODA", "highVIn = %d highVOut = %d text = %s",
			       i*2, i*100, temp);
#ifndef __vxworks
    sleep (1);
#else
    taskDelay (sysClkRateGet ());
#endif
  }
#ifndef __vxworks
  gettimeofday (&ftv, 0);
#else
  clock_gettime (CLOCK_REALTIME, &ftv);
#endif
  printf ("Time difference is %d\n", ftv.tv_sec - itv.tv_sec);

#ifndef __vxworks
  while (1)
    pause ();
#endif
}
