// Test program for list
#include <cpThread.h>
#include <cpThreadManager.h>
#include <cpSynch.h>

#include "cmlogDataQueue.h"
#include "cmlogMsg.h"

// create 10 reading threads, and 10 writing threads

void *
reader  (void *arg)
{
  cmlogDataQueue* queue = (cmlogDataQueue *)arg;
  
  for (;;) {
    cmlogMsg* msg = (cmlogMsg *)queue->dequeue ();
    cdevMessage& cmsg = (cdevMessage)(*msg);
    cmsg.asciiDump ();
    delete msg;
  }
  return 0;
}
  

void *
writer (void *arg)
{
  cmlogDataQueue* queue = (cmlogDataQueue *)arg;
  
  // create a new cmlogMsg
  cdevData data;
  cmlogMsg* msgs[10];

  for (int i = 0; i < 10; i++) {
    data.remove ();
    data.insert ("value", i*cpThread::self ());
    data.insert ("status", 0);
    cmlogMsg msg (1001, data, cpThread::self());
    msgs[i] = new cmlogMsg (msg);
  }

  int empty;
  for (i = 0; i < 10; i++) {
    queue->enqueue ((void *)msgs[i]);
    sleep (2);
  }
  return 0;
}


main (int argc, char **argv)
{
  cdevGlobalTagTable::tagTable ();

  // create an empty queue
  cmlogDataQueue queue;

  cpThreadManager manager;

  manager.spawn_n (10, CP_THREAD_FUNC (reader), (void *)&queue, 0);

  manager.spawn_n (10, CP_THREAD_FUNC (writer), (void *)&queue, 0);
  for (;;)
    pause ();
}

		   
