//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Server All Tags Memory Cache
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogTagTblData.h,v $
//   Revision 1.2  2000/06/20 19:32:50  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:40  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_TAG_TABLE_DATA_H
#define _CMLOG_TAG_TABLE_DATA_H

#include <cmlogData.h>

class cmlogTagTblData: public cmlogData
{
public:
  // constructors
  cmlogTagTblData  (char* name, char* file = (char *)CMLOG_TAGTABLE_NAME);
  cmlogTagTblData  (char* name, const cdevData& data,
		    char* file = (char *)CMLOG_TAGTABLE_NAME);
  // destructor
  ~cmlogTagTblData (void);

  void    update   (void);

  // no need to convert data from local to remote representation
  void    notifyChannels (void);

private:
  char* filename_;

  // deny access to copy and assignment operations
  cmlogTagTblData (const cmlogTagTblData& );
  cmlogTagTblData& operator = (const cmlogTagTblData& );
};
#endif


