//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogTagTblData Class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogTagTblData.cc,v $
//   Revision 1.2  2001/07/25 14:26:38  chen
//   64 BIT Initial Port
//
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:39  bickley
// Added cmlog to application development system.
//
//
//
#include <cmlogUtil.h>
#include <cmlogBrowserIO.h>
#include "cmlogTagTblData.h"

cmlogTagTblData::cmlogTagTblData (char* name, char* filename)
:cmlogData (name)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogTagTblData Class Object\n");
#endif
  filename_ = new char[::strlen (filename) + 1];
  ::strcpy (filename_, filename);
}

cmlogTagTblData::cmlogTagTblData (char* name, const cdevData& data,
				  char* filename)
:cmlogData (name, data)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogTagTblData Class Object\n");
#endif
  filename_ = new char[::strlen (filename) + 1];
  ::strcpy (filename_, filename);
}

cmlogTagTblData::~cmlogTagTblData (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogTagTblData Class Object\n");
#endif
  delete []filename_;
}

void
cmlogTagTblData::update (void)
{
#ifdef CMLOG_USE_THREAD
  cpMutexGuard guard (lock_);
#endif

  FILE* fd = fopen (filename_, "r");
  int   i = 0, j = 0;
  if (fd) {
    int   value;
    char  tag[80];

    while (!feof (fd)) {
      if (fscanf (fd, "%d %s", &value, tag) >=2)
	i++;
    }

    // rewind to the top of the file
    fseek (fd, 0L, SEEK_SET);

    if (i > 0) {
      data_.remove ();
      
      char** tagnames = new char*[i];
      int*   values = new int[i];

      j = 0;
      while (!feof (fd)) {
	if (fscanf (fd, "%d %s", &value, tag) >=2) {
	  tagnames[j] = new char[::strlen (tag) + 1];
	  ::strcpy (tagnames[j], tag);
	  
	  values[j++] = value;
	}
      }
      // insert value/name pair to the data
      data_.insert (1, values, i);
      data_.insert (2, tagnames, i);

      // free all memory
      for (j = 0; j < i; j++)
	delete []tagnames[j];

      delete []tagnames;
      delete []values;
    }
    
    fclose (fd);

    // update all channels
    notifyChannels ();
  }
}

void
cmlogTagTblData::notifyChannels (void)
{
  unsigned qid;       // request id
  unsigned cbkid;     // callback id
  char*    reqmsg;    // request message
  cmlogBrowserIO *io; // iochannel
  cdevData rdata;     // retuning data
  cmlogPacket packet;

  cmlogSlistIterator ite (channels_);
  cmlog_cdevMessage *msg = 0;

  for (ite.init (); !ite; ++ite) {
    // constructing the returning message
    msg = (cmlog_cdevMessage *) ite ();
    qid = msg->getTransIndex ();
    cbkid = msg->getForeignDataIndex ();
    reqmsg = msg->getMessage ();
    io = (cmlogBrowserIO *)msg->getArg ();

    // construct returning message    
    rdata = data_;
    rdata.insert (cmlogUtil::CMLOG_RESULT_TAG, CMLOG_SUCCESS);

    cmlog_cdevMessage rmsg (0, qid, 0, 0, cbkid, 0, 0, 0, reqmsg, &rdata, 0, 0);
    cmlogMsg    cmlogrmsg (rmsg);


    if (packet.overflow (cmlogrmsg)) {
      cdevData tdata;
      tdata.insert (cmlogUtil::CMLOG_RESULT_TAG, CMLOG_ERROR);
      cmlog_cdevMessage trmsg (0, qid, 0, 0, cbkid, 0, 0, 0, reqmsg, &tdata, 0, 0);
      cmlogMsg    tcmlogrmsg (trmsg);
      packet.insert (tcmlogrmsg);
    }
    else 
      packet.insert (cmlogrmsg);

#ifdef _CMLOG_DEBUG
    if (io == 0) 
      fprintf (stderr, "IO channel empty: should never happen\n");
#endif
    // send out result
    io->sendResult (packet);
    
    // empty packet
    packet.empty ();
    // empty data object
    rdata.remove ();
  }
}
    
    

      
