//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
//
// Description:
//       cmlog server locater internal engine
//
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogSvcLocaterRep.cc,v $
//   Revision 1.2  2001/07/25 14:26:38  chen
//   64 BIT Initial Port
//
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:36  bickley
// Added cmlog to application development system.
//
//
#include "cmlogSvcLocaterRep.h"
#include "cmlogServerLocater.h"

cmlogSvcLocaterRep::cmlogSvcLocaterRep (ACE_Reactor& r, 
					unsigned short port,
					unsigned req)
:reactor_ (r), brdcaster_ (ACE_Addr::sap_any),
 foundServer_ (0), port_ (port), req_ (req), serverHost_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogSvcLocaterRep Class Objects\n");
#endif
}

int
cmlogSvcLocaterRep::handle_close (int, ACE_Reactor_Mask)
{
  return brdcaster_.close ();
}

cmlogSvcLocaterRep::~cmlogSvcLocaterRep (void)
{
  if (serverHost_)
    delete []serverHost_;

  handle_close (-1, ACE_Event_Handler::READ_MASK);
}

int
cmlogSvcLocaterRep::foundServer (void) const
{
  return foundServer_;
}

int
cmlogSvcLocaterRep::get_handle (void) const
{
  return brdcaster_.get_handle ();
}

int
cmlogSvcLocaterRep::handle_input (int)
{
  ACE_INET_Addr   sa;
  unsigned  short port;
  int             n;

  if ( (n = brdcaster_.recv (&port, sizeof (unsigned short), sa)) == -1){
    return -1;
  }
  else {
    serverPort_ = ntohs (port);
    if (serverHost_)
      delete []serverHost_;
    serverHost_ = new char[::strlen (sa.get_host_name ()) + 1];
    ::strcpy (serverHost_, sa.get_host_name ());
#ifdef _CMLOG_DEBUG
    printf ("server is on %s and at TCP port %d\n",serverHost_, serverPort_);
#endif
    if (serverPort_ != 0) {
      foundServer_ = 1;
      reactor_.remove_handler (this, ACE_Event_Handler::READ_MASK);
    }
    return 0;
  }
}


int
cmlogSvcLocaterRep::sendRequest (void)
{
  int      status = 0;
  unsigned req = htonl (req_);

  // check environment variable CMLOG_HOST
  // if CMLOG_HOST is present, just send to this address
  char* cmlog_host = getenv ("CMLOG_HOST");
  if (cmlog_host) {
    ACE_INET_Addr addr;
    if (addr.set (port_, cmlog_host) != -1) {
      return brdcaster_.send ((char *)&req, sizeof (unsigned), addr);
    }
    else 
      return -1;
  }

  // else do broadcast here
  return brdcaster_.send ((char *)&req, sizeof (unsigned), port_);
}

