//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
//
// Description:
//       cmlog Server locater
//
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogServerLocater.h,v $
//   Revision 1.2  2001/07/25 14:26:38  chen
//   64 BIT Initial Port
//
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:29  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_SERVER_LOCATER_H
#define _CMLOG_SERVER_LOCATER_H

#include <cmlogProtocol.h>
#include "cmlogSvcLocaterRep.h"

typedef int (*cmlogUpdateFunc)(void *);

class cmlogServerLocater
{
public:
  // constructor and destructor
  // caller provide request protocol, experiment name and number of retries
  cmlogServerLocater  (unsigned req, 
		       int numRetries);

  cmlogServerLocater  (unsigned req, 
		       unsigned short port,
		       int      numRetries);
  ~cmlogServerLocater (void);

  // return cmlog server host name and requested port number
  // caller provide buffer and buffer size for hostName
  // return 0 for success
  int locatingServer (char* hostname, int size, unsigned short& port);

  // register external updating function
  void registerUpdateFunc (cmlogUpdateFunc func, void* arg);

private:
  unsigned short     brdPort_;
  int                numRetries_;
  unsigned           req_;
  // update external function
  cmlogUpdateFunc    ufunc_;
  void*              uarg_;
};

#endif
