//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlog Context data cache
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogCxtDataCache.cc,v $
//   Revision 1.2  2001/07/25 14:26:35  chen
//   64 BIT Initial Port
//
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:08  bickley
// Added cmlog to application development system.
//
//
//
#include <cmlogDatabase.h>
#include <cmlogUtil.h>
#include "cmlogCxtDataCache.h"


unsigned int cmlogCxtDataCache::cacheSize = 997;

cmlogCxtDataCache::cmlogCxtDataCache (char* filename)
:err_ (0), table_ (cmlogCxtDataCache::cacheSize)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogCxtDataCache Class Object\n");
#endif
  // load all information from filename to cache
  err_ = loadDataToCache (filename);

  if (err_) {
    cmlogUtil::serverPrintf ("Warning Cannot load context data from %s\n", filename);
    // clean up the context table
    table_.deleteAllValues ();
  }
}

cmlogCxtDataCache::~cmlogCxtDataCache (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogCxtDataCache Class Object\n");
#endif
  cdevData* data = 0;
  cmlogIntHashIterator ite (table_);

  for (ite.init (); !ite; ++ite) {
    data = (cdevData *)ite ();
    delete data;
  }
}

int
cmlogCxtDataCache::loadDataToCache (char* file)
{
  cdevData data;
  double   key = 0.0;

  cmlogDatabase dbase (file, O_RDONLY);
  if (dbase.cursorInit (data, &key) != CDEV_SUCCESS) {
    dbase.close ();
    return 1;
  }
  // insert this data into hash table
  cdevData* tdata = new cdevData (data);
  table_.add ((int)key, (void *)tdata);

  while (dbase.cursorNext (data, &key) == CDEV_SUCCESS) {
    tdata = new cdevData (data);
    table_.add ((int)key, (void *)tdata);
  }
  // close dbase
  dbase.close ();
  return 0;
}

cdevData*
cmlogCxtDataCache::getCxt (double key)
{
  cmlogSlist& list = table_.bucketRef ((int)key);
  cmlogSlistIterator ite (list);
  cdevData* data = 0;
  double    tkey = 0.0;

  
  for (ite.init (); !ite; ++ite) {
    data = (cdevData *) ite ();
    if (data->get (cmlogUtil::CMLOG_KEY_TAG, &tkey) == CDEV_SUCCESS &&
	tkey == key)
      return data;
  }
  return 0;
}

      


      
  
