//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Browser side callback Class Implementation
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: cmlogCallback.cc,v $
//   Revision 1.2  2001/07/25 14:26:34  chen
//   64 BIT Initial Port
//
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:04  bickley
// Added cmlog to application development system.
//
//
//
#include "cmlogCallback.h"

//==========================================================================
//     Implementation of cmlogCallback
//==========================================================================
cmlogCallback::cmlogCallback (void)
  :callback_ (0), userarg_ (0), evid_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogCallback Class Object\n");
#endif
  // empty
}

cmlogCallback::cmlogCallback (cmlogBrCallback cbk, void* arg)
  :callback_ (cbk), userarg_ (arg), evid_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogCallback Class Object\n");
#endif
  // empty
}

cmlogCallback::cmlogCallback (const cmlogCallback& cbk)
  :callback_ (cbk.callback_), userarg_ (cbk.userarg_), evid_ (cbk.evid_)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogCallback Class Object\n");
#endif
  // empty
}

cmlogCallback&
cmlogCallback::operator = (const cmlogCallback& cbk)
{
  if (this != &cbk) {
    callback_ = cbk.callback_;
    userarg_ = cbk.userarg_;
    evid_ = cbk.evid_;
  }
  return *this;
}

cmlogCallback::~cmlogCallback (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogCallback Class Object\n");
#endif
  // empty
}

cmlogBrCallback
cmlogCallback::callbackFunction (void) const
{
  return callback_;
}

void*
cmlogCallback::userarg (void) const
{
  return userarg_;
}

int
cmlogCallback::operator == (const cmlogCallback& cbk)
{
  if (callback_ == cbk.callback_ &&
      userarg_ == cbk.userarg_)
    return 1;
  else
    return 0;
}

int
cmlogCallback::operator != (const cmlogCallback& cbk)
{
  return ! operator == (cbk);
}

unsigned
cmlogCallback::getEvent (void) const
{
  return evid_;
}

void
cmlogCallback::setEvent (unsigned id)
{
  evid_ = id;
}


