//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Query Service Updating Object
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: cmlogQUpdateObj.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/09/18  14:28:58  chen
// new cmlog query service
//
//
//
//
#ifndef _CMLOG_Q_UPDATE_OBJ_H
#define _CMLOG_Q_UPDATE_OBJ_H

#include <cdevTranObj.h>

// class cmlogQUpdateObj is a monitor object that is very similar to
// the cdevTranObj except no group information. It will be used
// in the case of monitoring a particular channel which the user 
// callback need to be around after the transaction object goes away.

class cmlogQUpdateObj
{
public:
  // constructor and destructor
  cmlogQUpdateObj  (cdevTranObj& tranObj);
  ~cmlogQUpdateObj (void);

  const char *className (void) const {return "cmlogQUpdateObj";}

  // data area for requestObject to access
  cdevSystem        *system_;
  cdevRequestObject *reqObj_;
  cdevData          *resultData_;
  cdevCallback      *userCallback_;

  // pointer to transaction object
  cdevTranObj*      tobj_;

private:
  // deny access to copy and assignment
  cmlogQUpdateObj (const cmlogQUpdateObj&);
  cmlogQUpdateObj& operator = (const cmlogQUpdateObj&);
};
#endif
