//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	CODA Xpm Toggle Button X interface
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: XcodaXpmtbtnInterface.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:25:41  bickley
// Added cmlog to application development system.
//
//   Revision 1.1.1.1  1996/10/10 19:24:59  chen
//   coda motif C++ library
//
//
#ifndef _X_CODA_XPMTBTN_IFACE_H
#define _X_CODA_XPMTBTN_IFACE_H

#include <XcodaTbtnInterface.h>

class XcodaXpm;

class XcodaXpmtbtnInterface: public XcodaTbtnInterface
{
public: 
  XcodaXpmtbtnInterface (Widget parent, char **pix, char **sel_pix,
			 codaComd *cmd, 
			 int notoggle, int state);
  XcodaXpmtbtnInterface (Widget parent, char **pix, char **sel_pix,
			 codaComd *cmd, 
			 int notoggle, int state, char *bgsymbol);
  virtual ~XcodaXpmtbtnInterface();
  
  virtual void init();

  // return pixmaps
  XcodaXpm *pixmap          (void);
  XcodaXpm *selectionPixmap (void);
  // set pixmaps
  void     setPixmap          (XcodaXpm* xpm);
  void     setSelectionPixmap (XcodaXpm* xpm);

  virtual const char *className() const {return "XcodaXpmtbtnInterface";}

private:
  Widget   _parent;
  int      _initState;
  int      _notoggle;
  XcodaXpm *nxpm;
  XcodaXpm *selxpm;
};
#endif
