//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	Work Progress Dialog
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: XcodaProgDialog.h,v $
//   Revision 1.2  2000/06/20 18:46:22  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:08  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/09/24  17:49:01  chen
// modify addCallback pointer
//
//
//
#ifndef _XCODA_PROG_DIALOG_H
#define _XCODA_PROG_DIALOG_H

#include <XcodaFormDialog.h>

class XcodaProgDialog: public XcodaFormDialog
{
public:
  // destructor
  ~XcodaProgDialog (void);

  // update the progress dialog with absolue number
  void    update   (int number);

  // update the progress dialog with percentage number
  void    update   (float perc);

  // setup total number of tasks to finish
  void    taskNumber (int tnum);
  int     taskNumber (void) const;

  // class name
  virtual const char* className (void) const {return "XcodaProgDialog";}

protected:
  // constructor to prevent direct instantiation
  XcodaProgDialog (Widget parent, const char* name, const char* title);

  // cancel operation. derived classes implement this function
  virtual void cancel     (void) = 0;

  // inherited function
  void         createFormChildren (void);

  // cancel button callback
  static void  cancelCallback (Widget w, XtPointer data,
			       XmAnyCallbackStruct* cbs);

private:
  // real gauge widget
  Widget gw_;

  // task number
  int    taskNumber_;
};
#endif

  
