//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	Implementation of XcodaProgDialog Class
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: XcodaProgDialog.cc,v $
//   Revision 1.2  2000/06/20 18:46:22  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:08  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/09/24  17:48:59  chen
// modify addCallback pointer
//
//
//
#include <Xm/PushBG.h>
#include <Gauge.h>
#include "XcodaProgDialog.h"

XcodaProgDialog::XcodaProgDialog (Widget parent, const char* name,
				  const char* title)
:XcodaFormDialog (parent, name, title), gw_ (0), taskNumber_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Create XcodaProgDialog Class Object\n");
#endif
}

XcodaProgDialog::~XcodaProgDialog (void)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Delete XcodaProgDialog Class Object\n");
#endif
}

void
XcodaProgDialog::createFormChildren (void)
{
  Arg arg[30];
  int ac = 0;
  XmString t;

  // create cancel button
  t = XmStringCreateSimple ((char *)("Cancel"));
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  Widget cancel = XtCreateManagedWidget ("prog_cancel",
					 xmPushButtonGadgetClass,
					 _w, arg, ac);
  ac = 0;
  XmStringFree (t);
  // center this widget
  Dimension swd = 0;
  XtSetArg    (arg[ac], XmNwidth, &swd); ac++;
  XtGetValues (cancel, arg, ac); 
  ac = 0;
  XtSetArg    (arg[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg    (arg[ac], XmNleftPosition, 50); ac++;
  XtSetArg    (arg[ac], XmNleftOffset, -swd/2); ac++;
  XtSetValues (cancel, arg, ac);
  ac = 0; 

  // create gauge widget
  XtSetArg (arg[ac], XmNwidth,  300); ac++;
  XtSetArg (arg[ac], XmNheight, 20); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 10); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNbottomWidget, cancel); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 10); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 2); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 2); ac++;
  XtSetArg (arg[ac], XmNorientation, XmHORIZONTAL); ac++;
  XtSetArg (arg[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
  XtSetArg (arg[ac], XmNminimum, 0); ac++;
  XtSetArg (arg[ac], XmNmaximum, 10000); ac++;
  gw_ = XtCreateManagedWidget ("prog_gauge", xmGaugeWidgetClass,
			       _w, arg, ac);
  ac = 0;

  // add callback
  XtAddCallback (cancel, XmNactivateCallback,
		 (XtCallbackProc)&(XcodaProgDialog::cancelCallback),
		 (XtPointer)this);
}

void
XcodaProgDialog::taskNumber (int tnum)
{
  Arg arg[20];
  int ac = 0;

  taskNumber_ = tnum;
  XtSetArg (arg[ac], XmNmaximum, tnum); ac++;
  XtSetValues (gw_, arg, ac);
  ac = 0;
}

int
XcodaProgDialog::taskNumber (void) const
{
  return taskNumber_;
}

void
XcodaProgDialog::update (int num)
{
  Arg arg[20];
  int ac = 0;

  XtSetArg (arg[ac], XmNvalue, num); ac++;
  XtSetValues (gw_, arg, ac); 
  ac = 0;
}

void
XcodaProgDialog::update (float perc)
{
  Arg arg[20];
  int ac = 0;

  XtSetArg (arg[ac], XmNvalue, perc*taskNumber_); ac++;
  XtSetValues (gw_, arg, ac); 
  ac = 0;  
}

void
XcodaProgDialog::cancelCallback (Widget w, XtPointer data,
				 XmAnyCallbackStruct* cbs)
{
  XcodaProgDialog* obj = (XcodaProgDialog *)data;

  obj->popdown ();
  obj->cancel ();
}





  
					 
  
