/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: Gauge.c,v 1.1.1.1 1999/09/07 15:29:07 chen Exp $ */

#include <Xm/XmP.h>

#if (XmVersion >= 1002)
#include <Xm/DrawP.h>
#endif

#include "GaugeP.h"


void 
GaugePick(Widget w, XEvent *e, String *args, Cardinal  *num_args);
void 
GaugeDrag(Widget w, XEvent *e, String *args, Cardinal  *num_args);
void 
GaugeDrop(Widget w, XEvent *e, String *args, Cardinal  *num_args);



static char translations[] =
"<Btn1Down>: GaugePick()\n\
 <Btn1Motion>: GaugeDrag()\n\
 <Btn1Up>: GaugeDrop()\n\
";



static XtActionsRec actions[] = {
	{"GaugePick", GaugePick},
	{"GaugeDrag", GaugeDrag},
	{"GaugeDrop", GaugeDrop},
};

static void
DrawSlider(XmGaugeWidget gw, Boolean expose, int oldValue)
{
#define THIS gw->gauge
    Dimension size, sht, oldSize, tsh;
    float ratio, oldRatio;
    Boolean clear;
    
    if (!XtIsRealized((Widget)gw))
	return;
    
    sht = gw->primitive.shadow_thickness;
    ratio = (float)( (float)THIS.value - (float)THIS.minimum) / 
	( (float)THIS.maximum - (float)THIS.minimum);
    oldRatio = (float)( (float)oldValue - (float)THIS.minimum) / 
	( (float)THIS.maximum - (float)THIS.minimum);
    
    
    if (expose)
	clear = False;
    else
	clear = (oldValue > gw->gauge.value);
    
    tsh = THIS.troughShadowThickness;
    
    switch(THIS.orientation) 
	{
	case XmHORIZONTAL:
	    size = (gw->core.width - 2 * sht) * ratio;
	    if (clear)
		oldSize = (gw->core.width - 2 * sht) * oldRatio;
	    
	    switch(THIS.processingDirection) 
		{
		case XmMAX_ON_RIGHT:
		case XmMAX_ON_BOTTOM:
		    if (clear)
			XClearArea(XtDisplay(gw), XtWindow(gw), sht+size, sht,
				   (oldSize - size), gw->core.height - 2 * sht, FALSE);
		    else
			XFillRectangle(XtDisplay(gw), XtWindow(gw), THIS.gc,
				       sht+tsh, sht+tsh, size-2*tsh, (gw->core.height - 2 * sht) - 2*tsh);
		    
		    if (THIS.troughShadowThickness)
			_XmDrawShadows(XtDisplay(gw), XtWindow(gw), THIS.topGC, THIS.bottomGC,
				       sht, sht, size, gw->core.height - 2 * sht, tsh,
				       XmSHADOW_OUT);
		    break;
		    
		case XmMAX_ON_LEFT:
		case XmMAX_ON_TOP:
		    if (clear)
			XClearArea(XtDisplay(gw), XtWindow(gw), ((gw->core.width-sht) - oldSize), sht,
				   (oldSize-size), gw->core.height - 2 * sht, FALSE);
		    
		    if (!clear || expose)
			XFillRectangle(XtDisplay(gw), XtWindow(gw), THIS.gc,
				       (gw->core.width - size - sht), sht + tsh,
				       size - tsh, (gw->core.height - 2 * sht) - 2 * tsh);
		    
		    if (THIS.troughShadowThickness)
			_XmDrawShadows(XtDisplay(gw), XtWindow(gw), THIS.topGC, THIS.bottomGC,
				       gw->core.width - size - sht, sht, size, gw->core.height - 2 * sht, tsh,
				       XmSHADOW_OUT);
		    break;
		}
		    break;
		    
	case XmVERTICAL:
	    size = (gw->core.height - 2 * sht)* ratio;
	    if (clear)
		oldSize = (gw->core.height - 2 * sht) * oldRatio;
	    
	    switch(THIS.processingDirection) 
		{
		case XmMAX_ON_RIGHT:
		case XmMAX_ON_BOTTOM:
		    if (clear)
			XClearArea(XtDisplay(gw), XtWindow(gw), sht, sht+size,
				   gw->core.width - 2 * sht, (oldSize - size), FALSE);
		    
		    if (!clear || expose)
			XFillRectangle(XtDisplay(gw), XtWindow(gw), THIS.gc,
				       sht+tsh, sht+tsh, (gw->core.width - 2 * sht) - 2 * tsh, size-tsh);
		    
		    if (THIS.troughShadowThickness)
			_XmDrawShadows(XtDisplay(gw), XtWindow(gw), THIS.topGC, THIS.bottomGC,
				       sht, sht, (gw->core.width - 2 * sht), size,
				       tsh, XmSHADOW_OUT);
		    break;
		    
		case XmMAX_ON_LEFT:
		case XmMAX_ON_TOP:
		    if (clear)
			XClearArea(XtDisplay(gw), XtWindow(gw), sht, ((gw->core.height-sht) - oldSize),
				   gw->core.width - 2 * sht, (oldSize-size), FALSE);
		    
		    if (!clear || expose)
			XFillRectangle(XtDisplay(gw), XtWindow(gw), THIS.gc,
				       sht+tsh, (gw->core.height - size - sht),
				       (gw->core.width - 2 * sht) - 2 * tsh, size-tsh);
		    
		    if (THIS.troughShadowThickness)
			_XmDrawShadows(XtDisplay(gw), XtWindow(gw), THIS.topGC, THIS.bottomGC,
				       sht, (gw->core.height - size - sht), 
				       (gw->core.width - 2 * sht), size,
				       tsh, XmSHADOW_OUT);
		}
		    break;
	}
#undef THIS	
}


static void
getGCs(Widget w)
{
	XmGaugeWidget gw = (XmGaugeWidget)w;
#define THIS gw->gauge
	XGCValues values;
	XtGCMask valueMask;
	XmColorData *colorData;

	colorData = _XmGetColors(XtScreen(w), gw->core.colormap, gw->primitive.foreground);

	valueMask = GCForeground;
	values.foreground = gw->primitive.foreground;
	THIS.gc = XtGetGC(w, GCForeground, &values);

	if (THIS.troughShadowThickness)
	{
		values.foreground = _XmAccessColorData(colorData, XmTOP_SHADOW);
		THIS.topGC = XtGetGC ((Widget) w, valueMask, &values);

		values.foreground = _XmAccessColorData(colorData, XmBOTTOM_SHADOW);
		THIS.bottomGC = XtGetGC ((Widget) w, valueMask, &values);
	}
#undef THIS
}

static void
freeGCs(Widget w)
{
	XmGaugeWidget gw = (XmGaugeWidget)w;
#define THIS gw->gauge
	XtReleaseGC(w, THIS.gc);
	if (THIS.troughShadowThickness)
	{
		XtReleaseGC(w, THIS.topGC);
		XtReleaseGC(w, THIS.bottomGC);
	}
#undef THIS
}


static void
Initialize(Widget req, Widget new_w, ArgList args, Cardinal *num_args )
{
	XmGaugeWidget gw = (XmGaugeWidget)new_w;
#define THIS gw->gauge
	if (new_w->core.width == 0)
		new_w->core.width = THIS.troughShadowThickness ? (2 * THIS.troughShadowThickness + 5) : 5;

	if (new_w->core.height == 0)
		new_w->core.height = THIS.troughShadowThickness ? (2 * THIS.troughShadowThickness + 5) : 5;

	getGCs(new_w);
#undef THIS
}



static void
Destroy(Widget w)
{
	freeGCs(w);
}



	
static Boolean
SetValues(
		Widget cw,
		Widget rw,
		Widget nw,
		ArgList args,
		Cardinal *num_args )
{
	XmGaugeWidget cgw = (XmGaugeWidget)cw;
	XmGaugeWidget ngw = (XmGaugeWidget)nw;

	Boolean redraw = False;
	if(cgw->primitive.foreground != ngw->primitive.foreground) {

	freeGCs(nw);
	getGCs(nw);
	redraw = True;

	}
	if(cgw->gauge.value != ngw->gauge.value) {
	redraw = True;
	}
	return redraw;
}




static void
ExposeProc(Widget w, XEvent *event, Region r)
{
	XmGaugeWidget gw = (XmGaugeWidget)w;
#define THIS gw->gauge
	int sht;

	sht = gw->primitive.shadow_thickness;
	_XmDrawShadows(XtDisplay(w), XtWindow(w),
		   gw->primitive.top_shadow_GC,
		   gw->primitive.bottom_shadow_GC,
		   0, 0, w->core.width, w->core.height,
		   sht, XmSHADOW_IN);
	DrawSlider(gw, True, 0);
#undef THIS	
}





static XtResource 
resources[] = {
#define offset(field) XtOffset(XmGaugeWidget, gauge.field)
  {XmNvalue, XmCValue, XtRInt, sizeof(int),
	 offset(value), XtRImmediate, (XtPointer)10},
  
  {XmNminimum, XmCValue, XtRInt, sizeof(int),
	 offset(minimum), XtRImmediate, (XtPointer)0},
  
  {XmNmaximum, XmCValue, XtRInt, sizeof(int),
	 offset(maximum), XtRImmediate, (XtPointer)100},
  
  {XmNorientation, XmCOrientation, XmROrientation, sizeof(unsigned char),
	 offset(orientation), XtRImmediate, (XtPointer)XmVERTICAL},
  
  {XmNprocessingDirection, XmCProcessingDirection,
   XmRProcessingDirection, sizeof(unsigned char),
   offset(processingDirection), XtRImmediate, (XtPointer)XmMAX_ON_RIGHT},
  
  {XmNdragCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
	 offset(dragCallback), XtRImmediate, (XtPointer)NULL},
  
  {XmNvalueChangedCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
	 offset(valueChangedCallback), XtRImmediate, (XtPointer)NULL},

	{XmNtroughShadowThickness, XmCTroughShadowThickness, XmRHorizontalDimension, sizeof(Dimension),
		offset(troughShadowThickness), XmRImmediate, (XtPointer)2},
  
#undef offset
};


XmGaugeClassRec xmGaugeClassRec = {
	{				/* core fields */
	(WidgetClass) &xmPrimitiveClassRec, /* superclass		*/
	"XmGauge",		/* class_name		*/
	sizeof(XmGaugeRec),	/* widget_size		*/
	NULL,			/* class_initialize		*/
	NULL,			/* class_part_initialize	*/
	FALSE,			/* class_inited		*/
	Initialize,		/* initialize		*/
	NULL,			/* initialize_hook		*/
	XtInheritRealize,	/* realize			*/
	actions,		/* actions			*/
	XtNumber(actions),	/* num_actions		*/
	resources,		/* resources		*/
	XtNumber(resources),	/* num_resources		*/
	NULLQUARK,		/* xrm_class		*/
	TRUE,			/* compress_motion		*/
	TRUE,			/* compress_exposure	*/
	TRUE,			/* compress_enterleave	*/
	FALSE,			/* visible_interest		*/
	Destroy,		/* destroy			*/
	NULL,			/* resize			*/
	ExposeProc,		/* expose			*/
	SetValues,		/* set_values		*/
	NULL,			/* set_values_hook		*/
	XtInheritSetValuesAlmost, /* set_values_almost	*/
	NULL,			/* get_values_hook		*/
	NULL,			/* accept_focus		*/
	XtVersion,		/* version			*/
	NULL,			/* callback_private		*/
	translations,		/* tm_table			*/
	NULL,			/* query_geometry		*/
	NULL,			/* display_accelerator	*/
	NULL			/* extension		*/
	},
				/* primitive_class fields */
	{
	NULL,			/* border_highlight	*/
	NULL,			/* border_unhighlight	*/
	NULL,			/* translations		*/
	NULL,			/* arm_and_activate	*/
	NULL,			/* syn_resources	*/
	0,			/* num_syn_resources	*/
	NULL			/* extension		*/
	},
	{ /* gauge fields */
	0			/* empty		*/
	}
};

WidgetClass xmGaugeWidgetClass = (WidgetClass)&xmGaugeClassRec;




void 
GaugePick(Widget w, XEvent *e, String *args, Cardinal  *num_args)
{
	XmGaugeWidget gw = (XmGaugeWidget)w;
#define THIS gw->gauge
	int size, sht;
	float ratio;
	Boolean dragging = False;
	XButtonEvent *event = (XButtonEvent *)e;
	int x, y;

	x = event->x;
	y = event->y;
	sht = gw->primitive.shadow_thickness;
#if 0
	_XmDrawShadows(XtDisplay(w), XtWindow(w),
		   gw->primitive.top_shadow_GC,
		   gw->primitive.bottom_shadow_GC,
		   0, 0, w->core.width, w->core.height,
		   sht, XmSHADOW_IN);
#endif


    ratio = (float) ( (float)THIS.value - (float)THIS.minimum) /
                     ( (float)THIS.maximum - (float)THIS.minimum);	   
	switch(THIS.orientation) {
	case XmHORIZONTAL:
	size = (w->core.width - 2 * sht) * ratio;
	switch(THIS.processingDirection) {
	case XmMAX_ON_RIGHT:
	case XmMAX_ON_BOTTOM:
		dragging = (x > sht) && (y > sht) &&
		(x < sht + size) && (y < w->core.height - sht);
		break;
	case XmMAX_ON_LEFT:
	case XmMAX_ON_TOP:
		dragging = (x > w->core.width - size - sht) && (y > sht) &&
		(x < w->core.width - sht) && (y < w->core.height + sht);
		break;
	}
	break;
	case XmVERTICAL:
	size = (w->core.height - 2 * sht) * ratio;
	switch(THIS.processingDirection) {
	case XmMAX_ON_RIGHT:
	case XmMAX_ON_BOTTOM:
		dragging = (x > sht) && (y > sht) &&
		(x < w->core.width - sht) &&
		(y < w->core.width - 2 * sht + size);
		break;
	case XmMAX_ON_LEFT:
	case XmMAX_ON_TOP:
		dragging = (x > sht) && (y > w->core.height - size - sht) &&
		(x < w->core.width - sht) && (y < w->core.height - sht);
	}
	break;
	}
	THIS.dragging = dragging;
	THIS.oldx = x;
	THIS.oldy = y;
#undef THIS	
}

#define round(x) ( (x) > 0 ? ((x) + 0.5) : -(-(x) + 0.5) )

void 
GaugeDrag(Widget w, XEvent *e, String *args, Cardinal  *num_args)
{
    XmGaugeWidget gw = (XmGaugeWidget)w;
#define THIS gw->gauge
    int sht, x, y, max, oldValue;
    float ratio, nratio, size, nsize, fvalue, delta;
    XMotionEvent *event = (XMotionEvent *)e;
    
    if( ! THIS.dragging) return;
    
    x = event->x;
    y = event->y;
    sht = gw->primitive.shadow_thickness;
    
    ratio = (float) ( (float)THIS.value - (float)THIS.minimum) /
	( (float)THIS.maximum - (float)THIS.minimum);
    switch(THIS.orientation) {
    case XmHORIZONTAL:
	max = (w->core.width - 2 * sht);
	size = (float)max * ratio;
	delta =  (float)x - (float)THIS.oldx;
	break;
    case XmVERTICAL:
	max = (w->core.height - 2 * sht);
	size = (float) max * ratio;
	delta =  (float)y - (float)THIS.oldy;
	break;
    }
    switch(THIS.processingDirection) {
    case XmMAX_ON_RIGHT:
    case XmMAX_ON_BOTTOM:
	nsize = size + delta;
	break;
    default:
	nsize = size - delta;
    }
    if(nsize > (float)max) nsize = (float)max;
    if(nsize < (float)0 ) nsize = (float)0;
    nratio =  nsize / (float)max;
    oldValue = THIS.value;
    fvalue = ( (float)THIS.maximum - (float)THIS.minimum) * 
	(  (float)nsize / (float)max);

    
    THIS.value = round(fvalue);
    THIS.oldx = x;
    THIS.oldy = y;
    
    /* clear old slider only if it was larger */
    DrawSlider(gw, FALSE, oldValue);
    
    {
	XmGaugeCallbackStruct call;
	
	if(THIS.dragCallback) {
	    call.reason = XmCR_DRAG;
	    call.event = e;
	    call.value = THIS.value;
	    XtCallCallbacks(w, XmNdragCallback, &call);
	}
    }
#undef THIS	
}


void 
GaugeDrop(Widget w, XEvent *e, String *args, Cardinal  *num_args)
{
	XmGaugeWidget gw = (XmGaugeWidget)w;
#define THIS gw->gauge
	if( ! THIS.dragging) return;

	if( THIS.valueChangedCallback) {
	XmGaugeCallbackStruct call;
	call.reason = XmCR_VALUE_CHANGED;
	call.event = e;
	call.value = THIS.value;
	XtCallCallbacks(w, XmNvalueChangedCallback, &call);
	}
	THIS.dragging = False;
#undef THIS	
}


void
XmGaugeSetValue(Widget w, int value)
{
	XmGaugeWidget gw = (XmGaugeWidget)w;
	int oldValue;

	if (!XtIsSubclass(w, xmGaugeWidgetClass))
		return;

	oldValue = gw->gauge.value;

	if (value > gw->gauge.maximum)
		gw->gauge.value = gw->gauge.maximum;
	else
	if (value < gw->gauge.minimum)
		gw->gauge.value = gw->gauge.minimum;
	else
		gw->gauge.value = value;

	if (oldValue == value)
		return;

	DrawSlider(gw, FALSE, oldValue);
	XFlush(XtDisplay(w));
}

int
XmGaugeGetValue(Widget w)
{	
	XmGaugeWidget gw = (XmGaugeWidget)w;

	if (!XtIsSubclass(w, xmGaugeWidgetClass))
		return -1;

	return gw->gauge.value;
}
