// The following configuration file is designed to work
// for HP platforms running HP/UX 10.x.

#if !defined (ACE_CONFIG_H)
#error "You need to use a compiler-specific .h file - they include this file"
#endif

// Compiling for HPUX.
#if !defined (HPUX)
#define HPUX
#endif /* HPUX */

#ifndef _HPUX_SOURCE
#define _HPUX_SOURCE
#endif

// Some things are different for 10.10 vs. 10.20 vs. 10.30
// If the version number wasn't set up by the compiler command line,
// set up as if it was 10.20.
#if !defined (HPUX_VERS)
#define HPUX_VERS 1020
#endif

#if (HPUX_VERS < 1020)			// 10.10
#  define ACE_LACKS_TIMESPEC_T
#elif (HPUX_VERS < 1030)		// 10.20

   // Platform supports reentrant functions (all the POSIX *_r functions).
#  define ACE_HAS_REENTRANT_FUNCTIONS
   // But this one is not like other platforms
#  define ACE_CTIME_R_RETURNS_INT

#else					// 10.30
// Don't know yet... probably will be 10.20 but with some different thread
// settings.
#endif /* HPUX_VERS tests */

extern int h_errno;	/* This isn't declared in a header file on HP-UX */

// HP/UX needs to have these addresses in a special range.
// #define ACE_DEFAULT_BASE_ADDR ((char *) 0x80000000)

// Compiler/platform contains the <sys/syscall.h> file.
#define ACE_HAS_SYSCALL_H
// But doesn't have a prototype for syscall()
#define ACE_LACKS_SYSCALL

// Platform supports POSIX 1.b clock_gettime ()
#define ACE_HAS_CLOCK_GETTIME

// Compiler doesn't support static data member templates.
#define ACE_LACKS_STATIC_DATA_MEMBER_TEMPLATES


// #define ACE_LACKS_STRRECVFD
#define ACE_HAS_POSIX_TIME

// Platform supports System V IPC (most versions of UNIX, but not Win32)
#define ACE_HAS_SYSV_IPC			

// Platform supports recvmsg and sendmsg.
#define ACE_HAS_MSG

// Fixes a problem with HP/UX not wrapping the mmap(2) header files
// with extern "C".
#define ACE_HAS_BROKEN_MMAP_H

// Prototypes for both signal() and struct sigaction are consistent.
#define ACE_HAS_CONSISTENT_SIGNAL_PROTOTYPES

// Compiler/platform has correctly prototyped header files.
#define ACE_HAS_CPLUSPLUS_HEADERS

// Header files lack t_errno for ACE_TLI.
#define ACE_LACKS_T_ERRNO

// Compiler/platform supports poll().
#define ACE_HAS_POLL

// Platform supports POSIX O_NONBLOCK semantics.
#define ACE_HAS_POSIX_NONBLOCK

// Compiler/platform defines the sig_atomic_t typedef
#define ACE_HAS_SIG_ATOMIC_T
// Platform supports ucontext_t (which is used in the extended signal API).
#define ACE_HAS_UCONTEXT_T

// Compiler supports the ssize_t typedef.
#define ACE_HAS_SSIZE_T

// Platform supports getpagesize() call
#define ACE_HAS_GETPAGESIZE
// Defines the page size of the system.
#define ACE_PAGE_SIZE 4096

// Platform supports IP multicast
#define ACE_HAS_IP_MULTICAST

// Compiler/platform supports strerror ().
#define ACE_HAS_STRERROR

// ???
#define ACE_HAS_SUNOS4_GETTIMEOFDAY

// HP/UX has an undefined syscall for GETRUSAGE...
#define ACE_HAS_SYSCALL_GETRUSAGE

// Note, this only works if the flag is set above!
#define ACE_HAS_GETRUSAGE

// Platform supports the tid_t type
#define ACE_HAS_TID_T

// Platform has XPG4 wide character support
#define ACE_HAS_XPG4_MULTIBYTE_CHAR

// Platform lacks readers/writer locks.
#define ACE_LACKS_RWLOCK_T



// Platform uses int for select() rather than fd_set.
// #define ACE_SELECT_USES_INT

// Platform has prototypes for ACE_TLI.
//#define ACE_HAS_TLI_PROTOTYPES
// Platform has the XLI version of ACE_TLI.
// #define ACE_HAS_XLI

// Turns off the tracing feature.
#if !defined (ACE_NTRACE)
#define ACE_NTRACE 1
#endif /* ACE_NTRACE */

